/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.test.support.keycloak;

import com.nimbusds.jose.util.JSONArrayUtils;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.cloud.services.common.security.test.support.RolesClaimProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@AutoConfiguration
@Component
@ConditionalOnProperty(value={"activiti.cloud.services.oauth2.iam-name"}, havingValue="keycloak", matchIfMissing=true)
public class KeycloakRolesClaimProvider
implements RolesClaimProvider {
    @Override
    public void setResourceRoles(Map<String, String[]> resourceRoles, Map<String, Object> claims) {
        Map resourceAccess = JSONObjectUtils.newJSONObject();
        for (String key : resourceRoles.keySet()) {
            Map resourceRolesJSON = JSONObjectUtils.newJSONObject();
            List resourceRolesArray = JSONArrayUtils.newJSONArray();
            resourceRolesArray.addAll(Arrays.asList(resourceRoles.get(key)));
            resourceRolesJSON.put("roles", resourceRolesArray);
            resourceAccess.put(key, resourceRolesJSON);
        }
        claims.put("resource_access", resourceAccess);
    }

    @Override
    public void setGlobalRoles(Set<String> globalRoles, Map<String, Object> claims) {
        Map realmAccess = JSONObjectUtils.newJSONObject();
        List globalRolesArray = JSONArrayUtils.newJSONArray();
        globalRolesArray.addAll(globalRoles);
        realmAccess.put("roles", globalRolesArray);
        claims.put("realm_access", realmAccess);
    }
}

