/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.test.identity;

import java.util.Map;
import org.springframework.graphql.client.WebSocketGraphQlClientInterceptor;
import reactor.core.publisher.Mono;

public final class JwtGraphQlClientInterceptor implements WebSocketGraphQlClientInterceptor {

    private static final String AUTHORIZATION = "Authorization";

    private final String token;

    public JwtGraphQlClientInterceptor(IdentityTokenProducer identityTokenProducer) {
        this.token = initToken(identityTokenProducer);
    }

    public JwtGraphQlClientInterceptor(String token) {
        this.token = "Bearer " + token;
    }

    @Override
    public Mono<Object> connectionInitPayload() {
        return Mono.just(Map.of("Authorization", this.token));
    }

    public String initToken(IdentityTokenProducer identityTokenProducer) {
        return identityTokenProducer.authorizationHeaders().getFirst(AUTHORIZATION);
    }
}
