/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starters.test.builder;

import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.runtime.model.impl.VariableInstanceImpl;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableCreatedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableDeletedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableUpdatedEventImpl;
import org.activiti.cloud.starters.test.EventsAggregator;

public class VariableEventContainedBuilder {
    private VariableInstanceImpl<?> variableInstance;
    private VariableInstanceImpl<?> beforeUpdateVariableInstance;
    private EventsAggregator eventsAggregator;

    public VariableEventContainedBuilder(EventsAggregator eventsAggregator) {
        this.eventsAggregator = eventsAggregator;
    }

    public <T> VariableEventContainedBuilder aCreatedVariable(String name, T value, String type) {
        return this.aCreatedVariableWithProcessDefinitionKey(name, value, type, null);
    }

    public <T> VariableEventContainedBuilder aCreatedVariableWithProcessDefinitionKey(String name, T value, String type, String processDefinitionKey) {
        this.variableInstance = this.buildVariable(name, type, value);
        CloudVariableCreatedEventImpl cloudVariableCreatedEvent = new CloudVariableCreatedEventImpl(this.variableInstance);
        cloudVariableCreatedEvent.setProcessDefinitionKey(processDefinitionKey);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{cloudVariableCreatedEvent});
        return this;
    }

    public <T> VariableEventContainedBuilder aCreatedVariable(String name, T value) {
        this.aCreatedVariable(name, value, this.resolveType(value));
        return this;
    }

    private <T> String resolveType(T value) {
        return value.getClass().getSimpleName().toLowerCase();
    }

    public <T> VariableEventContainedBuilder anUpdatedVariable(String name, T value, T beforeUpdateValue, String type) {
        this.beforeUpdateVariableInstance = this.buildVariable(name, type, beforeUpdateValue);
        this.variableInstance = this.buildVariable(name, type, value);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudVariableCreatedEventImpl(this.beforeUpdateVariableInstance), new CloudVariableUpdatedEventImpl(this.variableInstance, beforeUpdateValue)});
        return this;
    }

    public <T> VariableEventContainedBuilder aDeletedVariable(String name, T value, String type) {
        this.variableInstance = this.buildVariable(name, type, value);
        this.eventsAggregator.addEvents(new CloudRuntimeEvent[]{new CloudVariableCreatedEventImpl(this.variableInstance), new CloudVariableDeletedEventImpl(this.variableInstance)});
        return this;
    }

    private <T> VariableInstanceImpl<T> buildVariable(String name, String type, T value) {
        return new VariableInstanceImpl(name, type, value, null, null);
    }

    public VariableInstance onProcessInstance(ProcessInstance processInstance) {
        this.setProcessInstanceInfo(this.variableInstance, processInstance);
        this.setProcessInstanceInfo(this.beforeUpdateVariableInstance, processInstance);
        return this.variableInstance;
    }

    private void setProcessInstanceInfo(VariableInstanceImpl<?> variableInstance, ProcessInstance processInstance) {
        if (variableInstance != null) {
            variableInstance.setProcessInstanceId(processInstance.getId());
        }
    }

    public VariableInstance onTask(Task task) {
        this.setTaskInfo(this.variableInstance, task);
        this.setTaskInfo(this.beforeUpdateVariableInstance, task);
        return this.variableInstance;
    }

    private void setTaskInfo(VariableInstanceImpl<?> variableInstance, Task task) {
        if (variableInstance != null) {
            variableInstance.setProcessInstanceId(task.getProcessInstanceId());
            variableInstance.setTaskId(task.getId());
        }
    }
}

