/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starters.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.starters.test.MyProducer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;

public class EventsAggregator
implements MessageHandler {
    private List<CloudRuntimeEvent<?, ?>> events = new ArrayList();
    private MyProducer producer;
    private AtomicReference<Message<?>> errorMessageRef = new AtomicReference();

    public EventsAggregator(MyProducer producer) {
        this.producer = producer;
    }

    public EventsAggregator addEvents(CloudRuntimeEvent<?, ?> ... events) {
        this.events.addAll(Arrays.asList(events));
        return this;
    }

    public CloudRuntimeEvent<?, ?>[] sendAll() {
        ArrayList sentEvents = new ArrayList(this.events);
        this.errorMessageRef.set(null);
        this.producer.send(this.events.toArray(new CloudRuntimeEvent[0]));
        this.events.clear();
        return (CloudRuntimeEvent[])sentEvents.toArray(CloudRuntimeEvent[]::new);
    }

    public Optional<Throwable> sendAll(CloudRuntimeEvent<?, ?>[] events) {
        this.errorMessageRef.set(null);
        this.producer.send(events);
        return Optional.ofNullable(this.getException());
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        this.errorMessageRef.set(message);
    }

    public Throwable getException() {
        return Optional.ofNullable(this.errorMessageRef.get()).map(ErrorMessage.class::cast).map(GenericMessage::getPayload).orElse(null);
    }

    public EventsAggregator errorChannel(SubscribableChannel errorChannel) {
        errorChannel.subscribe((MessageHandler)this);
        return this;
    }
}

