/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starter.audit.configuration;

import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.common.swagger.springdoc.SwaggerDocUtils;
import org.activiti.cloud.services.audit.api.converters.CloudRuntimeEventModel;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuditSwaggerConfig
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean(name={"auditApi"})
    public GroupedOpenApi auditApi(@Value(value="${activiti.cloud.swagger.audit-base-path:}") String swaggerBasePath) {
        return GroupedOpenApi.builder().group("Audit").packagesToScan(new String[]{"org.activiti.cloud.services.audit"}).addOpenApiCustomizer(openApi -> openApi.addExtension("x-service-url-prefix", (Object)swaggerBasePath)).build();
    }

    public void afterPropertiesSet() throws Exception {
        SwaggerDocUtils.replaceWithClass(CloudRuntimeEvent.class, CloudRuntimeEventModel.class);
    }
}

