/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.model;

import java.util.Objects;
import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.api.process.model.impl.IntegrationErrorImpl;
import org.activiti.cloud.connectors.starter.configuration.ConnectorProperties;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class IntegrationErrorBuilder {
    private final IntegrationRequest integrationRequest;
    private final ConnectorProperties connectorProperties;
    private final Throwable error;

    private IntegrationErrorBuilder(IntegrationRequest integrationRequest, ConnectorProperties connectorProperties, Throwable error) {
        this.integrationRequest = integrationRequest;
        this.connectorProperties = connectorProperties;
        this.error = error;
    }

    public static IntegrationErrorBuilder errorFor(IntegrationRequest integrationRequest, ConnectorProperties connectorProperties, Throwable error) {
        return new IntegrationErrorBuilder(integrationRequest, connectorProperties, error);
    }

    public IntegrationError build() {
        Objects.requireNonNull(this.integrationRequest);
        Objects.requireNonNull(this.error);
        IntegrationErrorImpl integrationError = new IntegrationErrorImpl(this.integrationRequest, this.error);
        if (this.connectorProperties != null) {
            integrationError.setAppVersion(this.connectorProperties.getAppVersion());
            integrationError.setServiceFullName(this.connectorProperties.getServiceFullName());
            integrationError.setServiceType(this.connectorProperties.getServiceType());
            integrationError.setServiceVersion(this.connectorProperties.getServiceVersion());
            integrationError.setServiceName(this.connectorProperties.getServiceName());
        }
        return integrationError;
    }

    public Message<IntegrationError> buildMessage() {
        return this.getMessageBuilder().build();
    }

    public MessageBuilder<IntegrationError> getMessageBuilder() {
        IntegrationError integrationError = this.build();
        return MessageBuilder.withPayload((Object)integrationError).setHeader("contentType", (Object)"application/json").setHeader("targetAppName", (Object)this.integrationRequest.getAppName()).setHeader("targetService", (Object)this.integrationRequest.getServiceFullName());
    }
}

