/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.channels;

import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.api.process.model.IntegrationResult;
import org.activiti.cloud.connectors.starter.channels.IntegrationResultChannelResolver;
import org.activiti.cloud.connectors.starter.channels.IntegrationResultSender;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class IntegrationResultSenderImpl
implements IntegrationResultSender {
    private final StreamBridge streamBridge;
    private final IntegrationResultChannelResolver resolver;

    public IntegrationResultSenderImpl(StreamBridge streamBridge, IntegrationResultChannelResolver resolver) {
        this.streamBridge = streamBridge;
        this.resolver = resolver;
    }

    @Override
    public void send(Message<IntegrationResult> message) {
        IntegrationRequest request = ((IntegrationResult)message.getPayload()).getIntegrationRequest();
        String destination = this.resolver.resolveDestination(request);
        this.streamBridge.send(destination, (Object)MessageBuilder.fromMessage(message).setHeader("spring.cloud.function.destination", (Object)destination).build());
    }
}

