/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.channels;

import java.util.Optional;
import java.util.function.Predicate;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.connectors.starter.channels.IntegrationErrorDestinationBuilder;
import org.activiti.cloud.connectors.starter.configuration.ConnectorProperties;
import org.springframework.util.ObjectUtils;

public class IntegrationErrorDestinationBuilderImpl
implements IntegrationErrorDestinationBuilder {
    private final ConnectorProperties connectorProperties;

    public IntegrationErrorDestinationBuilderImpl(ConnectorProperties connectorProperties) {
        this.connectorProperties = connectorProperties;
    }

    @Override
    public String buildDestination(IntegrationRequest event) {
        String errorDestinationOverride = this.connectorProperties.getErrorDestinationOverride();
        String destination = ObjectUtils.isEmpty((Object)errorDestinationOverride) ? Optional.of(event).map(IntegrationRequest::getErrorDestination).filter(Predicate.not(ObjectUtils::isEmpty)).orElseGet(() -> this.getServiceDestination(event)) : errorDestinationOverride;
        return destination;
    }

    private String getServiceDestination(IntegrationRequest event) {
        return "integrationError" + this.connectorProperties.getMqDestinationSeparator() + event.getServiceFullName();
    }
}

