/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starter.messages.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.transaction.HazelcastTransactionManager;
import org.activiti.cloud.services.messages.core.config.MessagesCoreAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.hazelcast.lock.HazelcastLockRegistry;
import org.springframework.integration.hazelcast.metadata.HazelcastMetadataStore;
import org.springframework.integration.hazelcast.store.HazelcastMessageStore;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(before={MessagesCoreAutoConfiguration.class})
@ConditionalOnClass(value={HazelcastInstance.class})
public class HazelcastMessageStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Config hazelcastConfig() {
        Config config = new Config();
        config.getCPSubsystemConfig().setCPMemberCount(3);
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public PlatformTransactionManager transactionManager(HazelcastInstance hazelcastInstance) {
        return new HazelcastTransactionManager(hazelcastInstance);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageGroupStore messageStore(HazelcastInstance hazelcastInstance) {
        HazelcastMessageStore messageStore = new HazelcastMessageStore(hazelcastInstance);
        messageStore.setLazyLoadMessageGroups(false);
        return messageStore;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConcurrentMetadataStore metadataStore(HazelcastInstance hazelcastInstance) {
        return new HazelcastMetadataStore(hazelcastInstance);
    }

    @Bean
    @ConditionalOnMissingBean
    public LockRegistry lockRegistry(HazelcastInstance hazelcastInstance) {
        return new HazelcastLockRegistry(hazelcastInstance);
    }
}

