/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starter.rb.configuration;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import org.activiti.api.process.model.payloads.CreateProcessInstancePayload;
import org.activiti.api.process.model.payloads.RemoveProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.SaveTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.cloud.common.swagger.springdoc.SwaggerDocUtils;
import org.activiti.cloud.starter.rb.configuration.PayloadApiModels;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
public class RuntimeBundleSwaggerConfig
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean(name={"runtimeBundleApi"})
    public GroupedOpenApi runtimeBundleApi(@Value(value="${activiti.cloud.swagger.rb-base-path:}") String swaggerBasePath) {
        return GroupedOpenApi.builder().group("Runtime Bundle").packagesToScan(new String[]{"org.activiti.cloud.services.rest"}).addOpenApiCustomizer(openApi -> openApi.addExtension("x-service-url-prefix", (Object)swaggerBasePath)).addOpenApiCustomizer(this.openApiCustomizer()).build();
    }

    public OpenApiCustomizer openApiCustomizer() {
        return openAPI -> openAPI.getPaths().values().stream().flatMap(val -> val.readOperations().stream()).flatMap(operation -> operation.getResponses().entrySet().stream()).filter(entry -> ((String)entry.getKey()).matches(String.valueOf(HttpStatus.OK.value()))).forEach(entry -> {
            Content contents = ((ApiResponse)entry.getValue()).getContent();
            String applicationHal = "application/hal+json";
            String applicationJson = "application/json";
            if (contents != null && contents.containsKey((Object)applicationHal) && contents.containsKey((Object)applicationJson)) {
                MediaType applicationHalValue = (MediaType)contents.remove((Object)applicationHal);
                contents.put((Object)applicationHal, (Object)applicationHalValue);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        SwaggerDocUtils.replaceWithClass(StartProcessPayload.class, PayloadApiModels.StartProcessPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(SignalPayload.class, PayloadApiModels.SignalPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(UpdateProcessPayload.class, PayloadApiModels.UpdateProcessPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(SetProcessVariablesPayload.class, PayloadApiModels.SetProcessVariablesPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(RemoveProcessVariablesPayload.class, PayloadApiModels.RemoveProcessVariablesPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(AssignTaskPayload.class, PayloadApiModels.AssignTaskPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CompleteTaskPayload.class, PayloadApiModels.CompleteTaskPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CandidateGroupsPayload.class, PayloadApiModels.CandidateGroupsPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CandidateUsersPayload.class, PayloadApiModels.CandidateUsersPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CreateTaskPayload.class, PayloadApiModels.CreateTaskPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CreateTaskVariablePayload.class, PayloadApiModels.CreateTaskVariablePayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(UpdateTaskVariablePayload.class, PayloadApiModels.UpdateTaskVariablePayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(UpdateTaskPayload.class, PayloadApiModels.UpdateTaskPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(SaveTaskPayload.class, PayloadApiModels.SaveTaskPayloadApiModel.class);
        SwaggerDocUtils.replaceWithClass(CreateProcessInstancePayload.class, PayloadApiModels.CreateProcessInstancePayloadApiModel.class);
    }
}

