/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.handler;

import feign.CollectionFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.alfresco.activiti.deployment.model.ApplicationCounter;
import org.alfresco.activiti.deployment.model.ApplicationLog;
import org.alfresco.activiti.deployment.model.ApplicationPostRequestRepresentation;
import org.alfresco.activiti.deployment.model.ApplicationPutRequestRepresentation;
import org.alfresco.activiti.deployment.model.ApplicationResponseRepresentation;
import org.alfresco.activiti.deployment.model.ErrorDTO;
import org.alfresco.activiti.deployment.model.ListResponseContentApplicationResponseRepresentation;
import org.alfresco.activiti.deployment.model.NamespaceHealth;
import org.alfresco.activiti.deployment.model.RuntimeVersionRepresentation;
import org.alfresco.activiti.deployment.model.SecurityRepresentation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="FindAndManageApplications", description="the FindAndManageApplications API")
public interface FindAndManageApplicationsApi {
    @ApiOperation(value="applicationExists", nickname="applicationExists", notes="Check if an application exists by name.", response=Boolean.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/exists"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Boolean> applicationExists(@NotNull @ApiParam(value="Full name of the application", required=true) @Valid @RequestParam(value="name", required=true) String var1, @ApiParam(value="Deployment environment's GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="checkApplicationQueue", nickname="checkApplicationQueue", notes="Check if application has rabbitmq configuration", response=String.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/check-queue"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> checkApplicationQueue(@ApiParam(value="Name of application to be checked", required=true) @PathVariable(value="name") String var1);

    @ApiOperation(value="createApplication", nickname="createApplication", notes="Create a new application.", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> createApplication(@ApiParam(value="", required=true) @Valid @RequestBody ApplicationPostRequestRepresentation var1);

    @ApiOperation(value="createApplicationQueue", nickname="createApplicationQueue", notes="Create application rabbitmq vhost", response=String.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/create-queue"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> createApplicationQueue(@ApiParam(value="Name of application", required=true) @PathVariable(value="name") String var1);

    @ApiOperation(value="createApplicationQueues", nickname="createApplicationQueues", notes="Create rabbitmq vhosts for all available applications", response=String.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/create-queues"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> createApplicationQueues();

    @ApiOperation(value="deleteApplication", nickname="deleteApplication", notes="", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> deleteApplication(@ApiParam(value="Name of application to delete", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="getApplication", nickname="getApplication", notes="Find application by name.", response=ApplicationResponseRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationResponseRepresentation> getApplication(@ApiParam(value="Name of application to return", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="getApplicationLimit", nickname="getApplicationLimit", notes="This service will return application usedCapacity, maximumCapacity and applicationLimitThreshHold.", response=ApplicationCounter.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationCounter.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/application-capacity"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationCounter> getApplicationLimit(@ApiParam(value="Filter on application name, showing all applications that contains the search key.") @Valid @RequestParam(value="name", required=false) String var1, @ApiParam(value="Application status", allowableValues="UpdateApp, CreateApp, CreateDescriptor, WaitingForDescriptor, ImageBuild, ImageBuildFailed, ImagePush, ImagePushFailed, DescriptorCreated, DeployStarted, DeployStartedFailed, UpgradeStartedFailed, UndeployFailed, NotDeployed, Pending, Running, Unknown, DeployIncomplete, EmptyContainer") @Valid @RequestParam(value="status", required=false) String var2, @ApiParam(value="Date used as start interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateFrom", required=false) LocalDate var3, @ApiParam(value="Date used as end interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateTo", required=false) LocalDate var4, @ApiParam(value="Roles that user must have on the application.") @Valid @RequestParam(value="roles", required=false) List<String> var5, @ApiParam(value="") @Valid @RequestParam(value="maxItems", required=false) Integer var6, @ApiParam(value="") @Valid @RequestParam(value="skipCount", required=false) Integer var7, @ApiParam(value="") @Valid @RequestParam(value="sort", required=false) String var8);

    @ApiOperation(value="getApplicationRuntimeVersion", nickname="getApplicationRuntimeVersion", notes="Retrieve the application runtime version by name.", response=RuntimeVersionRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=RuntimeVersionRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/runtime-version"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<RuntimeVersionRepresentation> getApplicationRuntimeVersion(@ApiParam(value="Name of application which runtime version is queried", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="getApplications", nickname="getApplications", notes="Find applications. It allows filtering. This service will return all applications if the user has ACTIVITI_DEVOPS role otherwise it returns only applications belonging to the user.", response=ListResponseContentApplicationResponseRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ListResponseContentApplicationResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ListResponseContentApplicationResponseRepresentation> getApplications(@ApiParam(value="Filter on application name, showing all applications that contains the search key.") @Valid @RequestParam(value="name", required=false) String var1, @ApiParam(value="Application status", allowableValues="UpdateApp, CreateApp, CreateDescriptor, WaitingForDescriptor, ImageBuild, ImageBuildFailed, ImagePush, ImagePushFailed, DescriptorCreated, DeployStarted, DeployStartedFailed, UpgradeStartedFailed, UndeployFailed, NotDeployed, Pending, Running, Unknown, DeployIncomplete, EmptyContainer") @Valid @RequestParam(value="status", required=false) String var2, @ApiParam(value="Date used as start interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateFrom", required=false) LocalDate var3, @ApiParam(value="Date used as end interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateTo", required=false) LocalDate var4, @ApiParam(value="Roles that user must have on the application.") @Valid @RequestParam(value="roles", required=false) List<String> var5, @ApiParam(value="") @Valid @RequestParam(value="maxItems", required=false) Integer var6, @ApiParam(value="") @Valid @RequestParam(value="skipCount", required=false) Integer var7, @ApiParam(value="") @Valid @RequestParam(value="sort", required=false) String var8, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) List<String> var9);

    @ApiOperation(value="getGroups", nickname="getGroups", notes="Fetch all groups belonging to an application.", response=String.class, responseContainer="List", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{appName}/groups"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<String>> getGroups(@ApiParam(value="ID of application", required=true) @PathVariable(value="appName") String var1, @ApiParam(value="Filter on group name, showing all groups that contains the search key") @Valid @RequestParam(value="name", required=false) String var2, @ApiParam(value="Roles that user must have on the application.") @Valid @RequestParam(value="roles", required=false) List<String> var3, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var4);

    @ApiOperation(value="getLatestRuntimeVersion", nickname="getLatestRuntimeVersion", notes="Retrieve the latest runtime version available in the deployment service.", response=RuntimeVersionRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=RuntimeVersionRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/runtime-versions/latest"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<RuntimeVersionRepresentation> getLatestRuntimeVersion();

    @ApiOperation(value="getRuntimeVersions", nickname="getRuntimeVersions", notes="Retrieve a list of runtime versions available in the deployment service.", response=RuntimeVersionRepresentation.class, responseContainer="List", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=RuntimeVersionRepresentation.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/runtime-versions"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<RuntimeVersionRepresentation>> getRuntimeVersions(@ApiParam(value="") @Valid @RequestParam(value="versionEqualOrLater", required=false) String var1);

    @ApiOperation(value="getUiVariables", nickname="getUiVariables", notes="List all variables for local development", response=String.class, responseContainer="Map", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=Map.class, responseContainer="Map"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/variables/ui"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Map<String, String>> getUiVariables(@ApiParam(value="Name of application to return", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Application Project ID") @Valid @RequestParam(value="projectId", required=false) String var2, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var3);

    @ApiOperation(value="getUsers", nickname="getUsers", notes="Fetch all users belonging to an application.", response=String.class, responseContainer="List", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{appName}/users"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<String>> getUsers(@ApiParam(value="ID of application", required=true) @PathVariable(value="appName") String var1, @ApiParam(value="Filter on username, showing all users that contains the search key") @Valid @RequestParam(value="name", required=false) String var2, @ApiParam(value="If the value is 'true' the service will return users belonging to the application, directly or via groups. Otherwise only users directly belonging to the application will be returned.", defaultValue="false") @Valid @RequestParam(value="group", required=false, defaultValue="false") Boolean var3, @ApiParam(value="Roles that user must have on the application.") @Valid @RequestParam(value="roles", required=false) List<String> var4, @ApiParam(value="If the value is 'true' the service will return only users belonging to the application. Otherwise user and service clients belonging to the application will be returned.", defaultValue="false") @Valid @RequestParam(value="excludeServiceClients", required=false, defaultValue="false") Boolean var5, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var6);

    @ApiOperation(value="redeployApplication", nickname="redeployApplication", notes="", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/redeploy"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> redeployApplication(@ApiParam(value="Name of application to redeploy", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="refreshApplication", nickname="refreshApplication", notes="Refresh an existing application by name for DR scenario.", response=ApplicationResponseRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/refresh"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationResponseRepresentation> refreshApplication(@ApiParam(value="Name of application to update", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="refreshCluster", nickname="refreshCluster", notes="Refresh whole cluster for DR scenario.", response=ApplicationResponseRepresentation.class, responseContainer="List", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationResponseRepresentation.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/refresh"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<ApplicationResponseRepresentation>> refreshCluster();

    @ApiOperation(value="retrieveApplicationServiceLogs", nickname="retrieveApplicationServiceLogs", notes="", response=ApplicationLog.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationLog.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/logs/{serviceName}"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationLog> retrieveApplicationServiceLogs(@ApiParam(value="Name of application to get logs from", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Name of the service to get logs from", required=true) @PathVariable(value="serviceName") String var2, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var3);

    @ApiOperation(value="retrieveDeploymentServiceLogs", nickname="retrieveDeploymentServiceLogs", notes="", response=ApplicationLog.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationLog.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/logs"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationLog> retrieveDeploymentServiceLogs(@ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var1);

    @ApiOperation(value="retrieveKubernetesNamespaceHealth", nickname="retrieveKubernetesNamespaceHealth", notes="", response=NamespaceHealth.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=NamespaceHealth.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/kubernetes/health"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<NamespaceHealth> retrieveKubernetesNamespaceHealth(@ApiParam(value="Name of application to get kubernetes health from", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="rollbackUpgradeApplication", nickname="rollbackUpgradeApplication", notes="Rollback to previous state by application name", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/rollback"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> rollbackUpgradeApplication(@ApiParam(value="Application Name to rollback", required=true) @PathVariable(value="name") String var1, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="uniqueNameExists", nickname="uniqueNameExists", notes="Check if an application with the same unique identifier exists by display name and environment ID.", response=Boolean.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/exists-in-env"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Boolean> uniqueNameExists(@NotNull @ApiParam(value="Display name of the application to be created", required=true) @Valid @RequestParam(value="name", required=true) String var1, @ApiParam(value="Desired environment's GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="updateApplicationRuntimeVersion", nickname="updateApplicationRuntimeVersion", notes="Updates the application runtime version to the selected one.", response=ApplicationResponseRepresentation.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ApplicationResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/update"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ApplicationResponseRepresentation> updateApplicationRuntimeVersion(@ApiParam(value="Name of application which runtime version is updated", required=true) @PathVariable(value="name") String var1, @ApiParam(value="") @Valid @RequestParam(value="runtimeVersion", required=false) String var2, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var3);

    @ApiOperation(value="updatePermission", nickname="updatePermission", notes="Update permission of an existing application.", response=String.class, tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}/security"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> updatePermission(@ApiParam(value="Name of application to update", required=true) @PathVariable(value="name") String var1, @ApiParam(value="", required=true) @Valid @RequestBody List<SecurityRepresentation> var2, @ApiParam(value="Deployment environment GUID") @Valid @RequestParam(value="environmentId", required=false) String var3);

    @ApiOperation(value="upgradeApplication", nickname="upgradeApplication", notes="Update an existing application by name.", tags={"Find and manage applications"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/applications/{name}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> upgradeApplication(@ApiParam(value="Name of application to update", required=true) @PathVariable(value="name") String var1, @ApiParam(value="", required=true) @Valid @RequestBody ApplicationPutRequestRepresentation var2);
}

