/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.handler;

import feign.CollectionFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import org.alfresco.activiti.deployment.model.DeployDescriptorRequestRepresentation;
import org.alfresco.activiti.deployment.model.DescriptorResponseRepresentation;
import org.alfresco.activiti.deployment.model.ErrorDTO;
import org.alfresco.activiti.deployment.model.JsonModel;
import org.alfresco.activiti.deployment.model.ListResponseContentDescriptorResponseRepresentation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Api(value="FindAndManageDescriptors", description="the FindAndManageDescriptors_ API")
public interface FindAndManageDescriptors_Api {
    @ApiOperation(value="deleteDescriptor", nickname="deleteDescriptor", notes="Delete an existing descriptor by name.", tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/{descriptorName}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> deleteDescriptor(@ApiParam(value="ID of application to delete", required=true) @PathVariable(value="descriptorName") String var1, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="deployDescriptor", nickname="deployDescriptor", notes="Deploy an existing descriptor by name.", tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/deploy/{descriptorName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> deployDescriptor(@ApiParam(value="ID of application to deploy", required=true) @PathVariable(value="descriptorName") String var1, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var2, @ApiParam(value="") @Valid @RequestBody DeployDescriptorRequestRepresentation var3);

    @ApiOperation(value="descriptorExists", nickname="descriptorExists", notes="Check if descriptor exists by name.", response=Boolean.class, tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/exists"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Boolean> descriptorExists(@NotNull @ApiParam(value="Full name of a descriptor", required=true) @Valid @RequestParam(value="name", required=true) String var1, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="exportDescriptor", nickname="exportDescriptor", notes="Export a descriptor by name.", tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/{descriptorName}/export"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public byte[] exportDescriptor(@ApiParam(value="", required=true) @PathVariable(value="descriptorName") String var1, @NotNull @ApiParam(value="", required=true, allowableValues="JSON") @Valid @RequestParam(value="type", required=true) String var2, @ApiParam(value="", defaultValue="true") @Valid @RequestParam(value="attachment", required=false, defaultValue="true") Boolean var3, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var4);

    @ApiOperation(value="getDescriptor", nickname="getDescriptor", notes="Find descriptor by name.", response=DescriptorResponseRepresentation.class, tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=DescriptorResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/{descriptorName}"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<DescriptorResponseRepresentation> getDescriptor(@ApiParam(value="ID of descriptor to return", required=true) @PathVariable(value="descriptorName") String var1, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var2);

    @ApiOperation(value="getDescriptors", nickname="getDescriptors", notes="Find descriptors. It allows filtering.", response=ListResponseContentDescriptorResponseRepresentation.class, tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=ListResponseContentDescriptorResponseRepresentation.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ListResponseContentDescriptorResponseRepresentation> getDescriptors(@ApiParam(value="Application status", allowableValues="UpdateApp, CreateApp, CreateDescriptor, WaitingForDescriptor, ImageBuild, ImageBuildFailed, ImagePush, ImagePushFailed, DescriptorCreated, DeployStarted, DeployStartedFailed, UpgradeStartedFailed, UndeployFailed, NotDeployed, Pending, Running, Unknown, DeployIncomplete, EmptyContainer") @Valid @RequestParam(value="status", required=false) String var1, @ApiParam(value="Filter on descriptor name, showing all descriptors that contains the search key.") @Valid @RequestParam(value="name", required=false) String var2, @ApiParam(value="Date used as start interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateFrom", required=false) LocalDate var3, @ApiParam(value="Date used as end interval in search by creation date. Allowed formats: yyyy-MM-dd or yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSS.") @Valid @RequestParam(value="createdDateTo", required=false) LocalDate var4, @ApiParam(value="") @Valid @RequestParam(value="maxItems", required=false) Integer var5, @ApiParam(value="") @Valid @RequestParam(value="skipCount", required=false) Integer var6, @ApiParam(value="") @Valid @RequestParam(value="sort", required=false) String var7, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) List<String> var8);

    @ApiOperation(value="getReleasedModelContents", nickname="getReleasedModelContents", notes="", response=JsonModel.class, responseContainer="List", tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=JsonModel.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/{descriptorName}/models"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<JsonModel>> getReleasedModelContents(@ApiParam(value="The id of the descriptor to get the models of the release", required=true) @PathVariable(value="descriptorName") String var1, @NotNull @ApiParam(value="The type of the models of the descriptor. Only CONNECTOR, AUTHENTICATION and UI types are available", required=true) @Valid @RequestParam(value="type", required=true) String var2, @ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var3);

    @ApiOperation(value="importDescriptor", nickname="importDescriptor", notes="Import descriptor. Format: zip file, containing at root a descriptor.json and the released project", tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/import"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> importDescriptor(@ApiParam(value="Deployment environments' GUIDs") @Valid @RequestParam(value="environmentId", required=false) String var1, @ApiParam(value="file detail") @Valid @PathVariable(value="file") MultipartFile var2);

    @ApiOperation(value="uniqueNameExists", nickname="uniqueNameExists", notes="Check if a descriptor with the same unique identifier exists by display name and environment ID.", response=Boolean.class, tags={"Find and manage descriptors."})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=ErrorDTO.class), @ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found")})
    @RequestMapping(value={"/v1/descriptors/exists-in-env"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Boolean> uniqueNameExists(@NotNull @ApiParam(value="Display name of the descriptor to be created", required=true) @Valid @RequestParam(value="name", required=true) String var1, @ApiParam(value="Desired environment's GUID") @Valid @RequestParam(value="environmentId", required=false) String var2);
}

