/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.AuthenticationRepresentation;
import org.alfresco.activiti.deployment.model.InfrastructureRepresentation;
import org.alfresco.activiti.deployment.model.SecurityRepresentation;
import org.alfresco.activiti.deployment.model.VariablesRepresentation;
import org.springframework.validation.annotation.Validated;

@Validated
public class ApplicationPutRequestRepresentation {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="releaseId")
    private String releaseId = null;
    @JsonProperty(value="security")
    @Valid
    private List<SecurityRepresentation> security = null;
    @JsonProperty(value="infrastructure")
    private InfrastructureRepresentation infrastructure = null;
    @JsonProperty(value="variables")
    private VariablesRepresentation variables = null;
    @JsonProperty(value="authentications")
    @Valid
    private Map<String, AuthenticationRepresentation> authentications = null;
    @JsonProperty(value="environmentId")
    private String environmentId = null;
    @JsonProperty(value="enableLocalDevelopment")
    private Boolean enableLocalDevelopment = null;
    @JsonProperty(value="customUIAuthFlowType")
    private CustomUIAuthFlowTypeEnum customUIAuthFlowType = null;
    @JsonProperty(value="forceMessagingBlueGreenMigration")
    private Boolean forceMessagingBlueGreenMigration = null;

    public ApplicationPutRequestRepresentation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationPutRequestRepresentation displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApplicationPutRequestRepresentation releaseId(String releaseId) {
        this.releaseId = releaseId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public ApplicationPutRequestRepresentation security(List<SecurityRepresentation> security) {
        this.security = security;
        return this;
    }

    public ApplicationPutRequestRepresentation addSecurityItem(SecurityRepresentation securityItem) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRepresentation>();
        }
        this.security.add(securityItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<SecurityRepresentation> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRepresentation> security) {
        this.security = security;
    }

    public ApplicationPutRequestRepresentation infrastructure(InfrastructureRepresentation infrastructure) {
        this.infrastructure = infrastructure;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public InfrastructureRepresentation getInfrastructure() {
        return this.infrastructure;
    }

    public void setInfrastructure(InfrastructureRepresentation infrastructure) {
        this.infrastructure = infrastructure;
    }

    public ApplicationPutRequestRepresentation variables(VariablesRepresentation variables) {
        this.variables = variables;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public VariablesRepresentation getVariables() {
        return this.variables;
    }

    public void setVariables(VariablesRepresentation variables) {
        this.variables = variables;
    }

    public ApplicationPutRequestRepresentation authentications(Map<String, AuthenticationRepresentation> authentications) {
        this.authentications = authentications;
        return this;
    }

    public ApplicationPutRequestRepresentation putAuthenticationsItem(String key, AuthenticationRepresentation authenticationsItem) {
        if (this.authentications == null) {
            this.authentications = new HashMap<String, AuthenticationRepresentation>();
        }
        this.authentications.put(key, authenticationsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, AuthenticationRepresentation> getAuthentications() {
        return this.authentications;
    }

    public void setAuthentications(Map<String, AuthenticationRepresentation> authentications) {
        this.authentications = authentications;
    }

    public ApplicationPutRequestRepresentation environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public ApplicationPutRequestRepresentation enableLocalDevelopment(Boolean enableLocalDevelopment) {
        this.enableLocalDevelopment = enableLocalDevelopment;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isEnableLocalDevelopment() {
        return this.enableLocalDevelopment;
    }

    public void setEnableLocalDevelopment(Boolean enableLocalDevelopment) {
        this.enableLocalDevelopment = enableLocalDevelopment;
    }

    public ApplicationPutRequestRepresentation customUIAuthFlowType(CustomUIAuthFlowTypeEnum customUIAuthFlowType) {
        this.customUIAuthFlowType = customUIAuthFlowType;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomUIAuthFlowTypeEnum getCustomUIAuthFlowType() {
        return this.customUIAuthFlowType;
    }

    public void setCustomUIAuthFlowType(CustomUIAuthFlowTypeEnum customUIAuthFlowType) {
        this.customUIAuthFlowType = customUIAuthFlowType;
    }

    public ApplicationPutRequestRepresentation forceMessagingBlueGreenMigration(Boolean forceMessagingBlueGreenMigration) {
        this.forceMessagingBlueGreenMigration = forceMessagingBlueGreenMigration;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isForceMessagingBlueGreenMigration() {
        return this.forceMessagingBlueGreenMigration;
    }

    public void setForceMessagingBlueGreenMigration(Boolean forceMessagingBlueGreenMigration) {
        this.forceMessagingBlueGreenMigration = forceMessagingBlueGreenMigration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPutRequestRepresentation applicationPutRequestRepresentation = (ApplicationPutRequestRepresentation)o;
        return Objects.equals(this.name, applicationPutRequestRepresentation.name) && Objects.equals(this.displayName, applicationPutRequestRepresentation.displayName) && Objects.equals(this.releaseId, applicationPutRequestRepresentation.releaseId) && Objects.equals(this.security, applicationPutRequestRepresentation.security) && Objects.equals(this.infrastructure, applicationPutRequestRepresentation.infrastructure) && Objects.equals(this.variables, applicationPutRequestRepresentation.variables) && Objects.equals(this.authentications, applicationPutRequestRepresentation.authentications) && Objects.equals(this.environmentId, applicationPutRequestRepresentation.environmentId) && Objects.equals(this.enableLocalDevelopment, applicationPutRequestRepresentation.enableLocalDevelopment) && Objects.equals((Object)this.customUIAuthFlowType, (Object)applicationPutRequestRepresentation.customUIAuthFlowType) && Objects.equals(this.forceMessagingBlueGreenMigration, applicationPutRequestRepresentation.forceMessagingBlueGreenMigration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.releaseId, this.security, this.infrastructure, this.variables, this.authentications, this.environmentId, this.enableLocalDevelopment, this.customUIAuthFlowType, this.forceMessagingBlueGreenMigration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationPutRequestRepresentation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    releaseId: ").append(this.toIndentedString(this.releaseId)).append("\n");
        sb.append("    security: ").append(this.toIndentedString(this.security)).append("\n");
        sb.append("    infrastructure: ").append(this.toIndentedString(this.infrastructure)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    authentications: ").append(this.toIndentedString(this.authentications)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    enableLocalDevelopment: ").append(this.toIndentedString(this.enableLocalDevelopment)).append("\n");
        sb.append("    customUIAuthFlowType: ").append(this.toIndentedString((Object)this.customUIAuthFlowType)).append("\n");
        sb.append("    forceMessagingBlueGreenMigration: ").append(this.toIndentedString(this.forceMessagingBlueGreenMigration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomUIAuthFlowTypeEnum {
        IMPLICIT("IMPLICIT"),
        CODE("CODE");

        private String value;

        private CustomUIAuthFlowTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomUIAuthFlowTypeEnum fromValue(String text) {
            for (CustomUIAuthFlowTypeEnum b : CustomUIAuthFlowTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

