/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.AuthenticationRepresentation;
import org.alfresco.activiti.deployment.model.InfrastructureRepresentation;
import org.alfresco.activiti.deployment.model.SecurityRepresentation;
import org.alfresco.activiti.deployment.model.VariablesRepresentation;
import org.springframework.validation.annotation.Validated;

@Validated
public class ApplicationRepresentation {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="releaseId")
    private String releaseId = null;
    @JsonProperty(value="projectId")
    private String projectId = null;
    @JsonProperty(value="projectName")
    private String projectName = null;
    @JsonProperty(value="projectKey")
    private String projectKey = null;
    @JsonProperty(value="releaseVersion")
    private Integer releaseVersion = null;
    @JsonProperty(value="runtimeBundleVersion")
    private String runtimeBundleVersion = null;
    @JsonProperty(value="security")
    @Valid
    private List<SecurityRepresentation> security = null;
    @JsonProperty(value="infrastructure")
    private InfrastructureRepresentation infrastructure = null;
    @JsonProperty(value="variables")
    private VariablesRepresentation variables = null;
    @JsonProperty(value="authentications")
    @Valid
    private Map<String, AuthenticationRepresentation> authentications = null;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="environmentId")
    private String environmentId = null;
    @JsonProperty(value="enableLocalDevelopment")
    private Boolean enableLocalDevelopment = null;
    @JsonProperty(value="customUIAuthFlowType")
    private CustomUIAuthFlowTypeEnum customUIAuthFlowType = null;

    public ApplicationRepresentation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationRepresentation displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApplicationRepresentation releaseId(String releaseId) {
        this.releaseId = releaseId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public ApplicationRepresentation projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public ApplicationRepresentation projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public ApplicationRepresentation projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @ApiModelProperty(value="")
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public ApplicationRepresentation releaseVersion(Integer releaseVersion) {
        this.releaseVersion = releaseVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(Integer releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public ApplicationRepresentation runtimeBundleVersion(String runtimeBundleVersion) {
        this.runtimeBundleVersion = runtimeBundleVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRuntimeBundleVersion() {
        return this.runtimeBundleVersion;
    }

    public void setRuntimeBundleVersion(String runtimeBundleVersion) {
        this.runtimeBundleVersion = runtimeBundleVersion;
    }

    public ApplicationRepresentation security(List<SecurityRepresentation> security) {
        this.security = security;
        return this;
    }

    public ApplicationRepresentation addSecurityItem(SecurityRepresentation securityItem) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRepresentation>();
        }
        this.security.add(securityItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<SecurityRepresentation> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRepresentation> security) {
        this.security = security;
    }

    public ApplicationRepresentation infrastructure(InfrastructureRepresentation infrastructure) {
        this.infrastructure = infrastructure;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public InfrastructureRepresentation getInfrastructure() {
        return this.infrastructure;
    }

    public void setInfrastructure(InfrastructureRepresentation infrastructure) {
        this.infrastructure = infrastructure;
    }

    public ApplicationRepresentation variables(VariablesRepresentation variables) {
        this.variables = variables;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public VariablesRepresentation getVariables() {
        return this.variables;
    }

    public void setVariables(VariablesRepresentation variables) {
        this.variables = variables;
    }

    public ApplicationRepresentation authentications(Map<String, AuthenticationRepresentation> authentications) {
        this.authentications = authentications;
        return this;
    }

    public ApplicationRepresentation putAuthenticationsItem(String key, AuthenticationRepresentation authenticationsItem) {
        if (this.authentications == null) {
            this.authentications = new HashMap<String, AuthenticationRepresentation>();
        }
        this.authentications.put(key, authenticationsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, AuthenticationRepresentation> getAuthentications() {
        return this.authentications;
    }

    public void setAuthentications(Map<String, AuthenticationRepresentation> authentications) {
        this.authentications = authentications;
    }

    public ApplicationRepresentation accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ApplicationRepresentation environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public ApplicationRepresentation enableLocalDevelopment(Boolean enableLocalDevelopment) {
        this.enableLocalDevelopment = enableLocalDevelopment;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isEnableLocalDevelopment() {
        return this.enableLocalDevelopment;
    }

    public void setEnableLocalDevelopment(Boolean enableLocalDevelopment) {
        this.enableLocalDevelopment = enableLocalDevelopment;
    }

    public ApplicationRepresentation customUIAuthFlowType(CustomUIAuthFlowTypeEnum customUIAuthFlowType) {
        this.customUIAuthFlowType = customUIAuthFlowType;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomUIAuthFlowTypeEnum getCustomUIAuthFlowType() {
        return this.customUIAuthFlowType;
    }

    public void setCustomUIAuthFlowType(CustomUIAuthFlowTypeEnum customUIAuthFlowType) {
        this.customUIAuthFlowType = customUIAuthFlowType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRepresentation applicationRepresentation = (ApplicationRepresentation)o;
        return Objects.equals(this.name, applicationRepresentation.name) && Objects.equals(this.displayName, applicationRepresentation.displayName) && Objects.equals(this.releaseId, applicationRepresentation.releaseId) && Objects.equals(this.projectId, applicationRepresentation.projectId) && Objects.equals(this.projectName, applicationRepresentation.projectName) && Objects.equals(this.projectKey, applicationRepresentation.projectKey) && Objects.equals(this.releaseVersion, applicationRepresentation.releaseVersion) && Objects.equals(this.runtimeBundleVersion, applicationRepresentation.runtimeBundleVersion) && Objects.equals(this.security, applicationRepresentation.security) && Objects.equals(this.infrastructure, applicationRepresentation.infrastructure) && Objects.equals(this.variables, applicationRepresentation.variables) && Objects.equals(this.authentications, applicationRepresentation.authentications) && Objects.equals(this.accountId, applicationRepresentation.accountId) && Objects.equals(this.environmentId, applicationRepresentation.environmentId) && Objects.equals(this.enableLocalDevelopment, applicationRepresentation.enableLocalDevelopment) && Objects.equals((Object)this.customUIAuthFlowType, (Object)applicationRepresentation.customUIAuthFlowType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.releaseId, this.projectId, this.projectName, this.projectKey, this.releaseVersion, this.runtimeBundleVersion, this.security, this.infrastructure, this.variables, this.authentications, this.accountId, this.environmentId, this.enableLocalDevelopment, this.customUIAuthFlowType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationRepresentation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    releaseId: ").append(this.toIndentedString(this.releaseId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    releaseVersion: ").append(this.toIndentedString(this.releaseVersion)).append("\n");
        sb.append("    runtimeBundleVersion: ").append(this.toIndentedString(this.runtimeBundleVersion)).append("\n");
        sb.append("    security: ").append(this.toIndentedString(this.security)).append("\n");
        sb.append("    infrastructure: ").append(this.toIndentedString(this.infrastructure)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    authentications: ").append(this.toIndentedString(this.authentications)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    enableLocalDevelopment: ").append(this.toIndentedString(this.enableLocalDevelopment)).append("\n");
        sb.append("    customUIAuthFlowType: ").append(this.toIndentedString((Object)this.customUIAuthFlowType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomUIAuthFlowTypeEnum {
        IMPLICIT("IMPLICIT"),
        CODE("CODE");

        private String value;

        private CustomUIAuthFlowTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomUIAuthFlowTypeEnum fromValue(String text) {
            for (CustomUIAuthFlowTypeEnum b : CustomUIAuthFlowTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

