/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.ApplicationRepresentation;
import org.springframework.validation.annotation.Validated;

@Validated
public class ApplicationResponseRepresentation {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="lastModifiedAt")
    private OffsetDateTime lastModifiedAt = null;
    @JsonProperty(value="descriptor")
    private ApplicationRepresentation descriptor = null;
    @JsonProperty(value="environmentId")
    private String environmentId = null;
    @JsonProperty(value="rollback")
    private Boolean rollback = null;
    @JsonProperty(value="deploymentCompletion")
    private Integer deploymentCompletion = null;

    public ApplicationResponseRepresentation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationResponseRepresentation displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApplicationResponseRepresentation status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ApplicationResponseRepresentation version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ApplicationResponseRepresentation createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ApplicationResponseRepresentation lastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public ApplicationResponseRepresentation descriptor(ApplicationRepresentation descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ApplicationRepresentation getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ApplicationRepresentation descriptor) {
        this.descriptor = descriptor;
    }

    public ApplicationResponseRepresentation environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public ApplicationResponseRepresentation rollback(Boolean rollback) {
        this.rollback = rollback;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(Boolean rollback) {
        this.rollback = rollback;
    }

    public ApplicationResponseRepresentation deploymentCompletion(Integer deploymentCompletion) {
        this.deploymentCompletion = deploymentCompletion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getDeploymentCompletion() {
        return this.deploymentCompletion;
    }

    public void setDeploymentCompletion(Integer deploymentCompletion) {
        this.deploymentCompletion = deploymentCompletion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationResponseRepresentation applicationResponseRepresentation = (ApplicationResponseRepresentation)o;
        return Objects.equals(this.name, applicationResponseRepresentation.name) && Objects.equals(this.displayName, applicationResponseRepresentation.displayName) && Objects.equals((Object)this.status, (Object)applicationResponseRepresentation.status) && Objects.equals(this.version, applicationResponseRepresentation.version) && Objects.equals(this.createdAt, applicationResponseRepresentation.createdAt) && Objects.equals(this.lastModifiedAt, applicationResponseRepresentation.lastModifiedAt) && Objects.equals(this.descriptor, applicationResponseRepresentation.descriptor) && Objects.equals(this.environmentId, applicationResponseRepresentation.environmentId) && Objects.equals(this.rollback, applicationResponseRepresentation.rollback) && Objects.equals(this.deploymentCompletion, applicationResponseRepresentation.deploymentCompletion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.status, this.version, this.createdAt, this.lastModifiedAt, this.descriptor, this.environmentId, this.rollback, this.deploymentCompletion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationResponseRepresentation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastModifiedAt: ").append(this.toIndentedString(this.lastModifiedAt)).append("\n");
        sb.append("    descriptor: ").append(this.toIndentedString(this.descriptor)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    rollback: ").append(this.toIndentedString(this.rollback)).append("\n");
        sb.append("    deploymentCompletion: ").append(this.toIndentedString(this.deploymentCompletion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UPDATEAPP("UpdateApp"),
        CREATEAPP("CreateApp"),
        CREATEDESCRIPTOR("CreateDescriptor"),
        WAITINGFORDESCRIPTOR("WaitingForDescriptor"),
        IMAGEBUILD("ImageBuild"),
        IMAGEBUILDFAILED("ImageBuildFailed"),
        IMAGEPUSH("ImagePush"),
        IMAGEPUSHFAILED("ImagePushFailed"),
        DESCRIPTORCREATED("DescriptorCreated"),
        DEPLOYSTARTED("DeployStarted"),
        DEPLOYSTARTEDFAILED("DeployStartedFailed"),
        UPGRADESTARTEDFAILED("UpgradeStartedFailed"),
        UNDEPLOYFAILED("UndeployFailed"),
        NOTDEPLOYED("NotDeployed"),
        PENDING("Pending"),
        RUNNING("Running"),
        UNKNOWN("Unknown"),
        DEPLOYINCOMPLETE("DeployIncomplete"),
        EMPTYCONTAINER("EmptyContainer");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

