/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.PodHealth;
import org.springframework.validation.annotation.Validated;

@Validated
public class DeploymentHealth {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="healthEndpoint")
    private String healthEndpoint = null;
    @JsonProperty(value="pods")
    @Valid
    private List<PodHealth> pods = null;
    @JsonProperty(value="deploymentStatus")
    private DeploymentStatusEnum deploymentStatus = null;
    @JsonProperty(value="replicas")
    private Integer replicas = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;

    public DeploymentHealth name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentHealth healthEndpoint(String healthEndpoint) {
        this.healthEndpoint = healthEndpoint;
        return this;
    }

    @ApiModelProperty(value="")
    public String getHealthEndpoint() {
        return this.healthEndpoint;
    }

    public void setHealthEndpoint(String healthEndpoint) {
        this.healthEndpoint = healthEndpoint;
    }

    public DeploymentHealth pods(List<PodHealth> pods) {
        this.pods = pods;
        return this;
    }

    public DeploymentHealth addPodsItem(PodHealth podsItem) {
        if (this.pods == null) {
            this.pods = new ArrayList<PodHealth>();
        }
        this.pods.add(podsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<PodHealth> getPods() {
        return this.pods;
    }

    public void setPods(List<PodHealth> pods) {
        this.pods = pods;
    }

    public DeploymentHealth deploymentStatus(DeploymentStatusEnum deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public DeploymentStatusEnum getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void setDeploymentStatus(DeploymentStatusEnum deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    public DeploymentHealth replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public DeploymentHealth status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentHealth deploymentHealth = (DeploymentHealth)o;
        return Objects.equals(this.name, deploymentHealth.name) && Objects.equals(this.healthEndpoint, deploymentHealth.healthEndpoint) && Objects.equals(this.pods, deploymentHealth.pods) && Objects.equals((Object)this.deploymentStatus, (Object)deploymentHealth.deploymentStatus) && Objects.equals(this.replicas, deploymentHealth.replicas) && Objects.equals((Object)this.status, (Object)deploymentHealth.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.healthEndpoint, this.pods, this.deploymentStatus, this.replicas, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentHealth {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    healthEndpoint: ").append(this.toIndentedString(this.healthEndpoint)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    deploymentStatus: ").append(this.toIndentedString((Object)this.deploymentStatus)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DeploymentStatusEnum {
        FOUND("DEPLOYMENT_FOUND"),
        MISSING("DEPLOYMENT_MISSING");

        private String value;

        private DeploymentStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeploymentStatusEnum fromValue(String text) {
            for (DeploymentStatusEnum b : DeploymentStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        DOWN("DOWN"),
        UNKNOWN("UNKNOWN"),
        LOADING("LOADING"),
        UP("UP");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

