/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.ApplicationRepresentation;
import org.springframework.validation.annotation.Validated;

@Validated
public class DescriptorResponseRepresentation {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="lastModifiedAt")
    private OffsetDateTime lastModifiedAt = null;
    @JsonProperty(value="descriptor")
    private ApplicationRepresentation descriptor = null;
    @JsonProperty(value="deployed")
    private Boolean deployed = null;

    public DescriptorResponseRepresentation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DescriptorResponseRepresentation displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DescriptorResponseRepresentation status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DescriptorResponseRepresentation createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DescriptorResponseRepresentation lastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public DescriptorResponseRepresentation descriptor(ApplicationRepresentation descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ApplicationRepresentation getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ApplicationRepresentation descriptor) {
        this.descriptor = descriptor;
    }

    public DescriptorResponseRepresentation deployed(Boolean deployed) {
        this.deployed = deployed;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(Boolean deployed) {
        this.deployed = deployed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorResponseRepresentation descriptorResponseRepresentation = (DescriptorResponseRepresentation)o;
        return Objects.equals(this.name, descriptorResponseRepresentation.name) && Objects.equals(this.displayName, descriptorResponseRepresentation.displayName) && Objects.equals((Object)this.status, (Object)descriptorResponseRepresentation.status) && Objects.equals(this.createdAt, descriptorResponseRepresentation.createdAt) && Objects.equals(this.lastModifiedAt, descriptorResponseRepresentation.lastModifiedAt) && Objects.equals(this.descriptor, descriptorResponseRepresentation.descriptor) && Objects.equals(this.deployed, descriptorResponseRepresentation.deployed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.status, this.createdAt, this.lastModifiedAt, this.descriptor, this.deployed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescriptorResponseRepresentation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastModifiedAt: ").append(this.toIndentedString(this.lastModifiedAt)).append("\n");
        sb.append("    descriptor: ").append(this.toIndentedString(this.descriptor)).append("\n");
        sb.append("    deployed: ").append(this.toIndentedString(this.deployed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UPDATEAPP("UpdateApp"),
        CREATEAPP("CreateApp"),
        CREATEDESCRIPTOR("CreateDescriptor"),
        WAITINGFORDESCRIPTOR("WaitingForDescriptor"),
        IMAGEBUILD("ImageBuild"),
        IMAGEBUILDFAILED("ImageBuildFailed"),
        IMAGEPUSH("ImagePush"),
        IMAGEPUSHFAILED("ImagePushFailed"),
        DESCRIPTORCREATED("DescriptorCreated"),
        DEPLOYSTARTED("DeployStarted"),
        DEPLOYSTARTEDFAILED("DeployStartedFailed"),
        UPGRADESTARTEDFAILED("UpgradeStartedFailed"),
        UNDEPLOYFAILED("UndeployFailed"),
        NOTDEPLOYED("NotDeployed"),
        PENDING("Pending"),
        RUNNING("Running"),
        UNKNOWN("Unknown"),
        DEPLOYINCOMPLETE("DeployIncomplete"),
        EMPTYCONTAINER("EmptyContainer");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

