/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.ServiceRepresentation;
import org.alfresco.activiti.deployment.model.UiInfrastructureRepresentation;
import org.springframework.validation.annotation.Validated;

@Validated
public class InfrastructureRepresentation {
    @JsonProperty(value="connectors")
    @Valid
    private Map<String, ServiceRepresentation> connectors = null;
    @JsonProperty(value="uis")
    @Valid
    private Map<String, UiInfrastructureRepresentation> uis = null;
    @JsonProperty(value="bridges")
    @Valid
    private Map<String, ServiceRepresentation> bridges = null;
    @JsonProperty(value="content-service")
    private ServiceRepresentation contentService = null;
    @JsonProperty(value="identity-service")
    private ServiceRepresentation identityService = null;
    @JsonProperty(value="process-runtime-service")
    private ServiceRepresentation processRuntimeService = null;
    @JsonProperty(value="query-service")
    private ServiceRepresentation queryService = null;
    @JsonProperty(value="process-storage-service")
    private ServiceRepresentation processStorageService = null;
    @JsonProperty(value="runtime-version")
    private String runtimeVersion = null;

    public InfrastructureRepresentation connectors(Map<String, ServiceRepresentation> connectors) {
        this.connectors = connectors;
        return this;
    }

    public InfrastructureRepresentation putConnectorsItem(String key, ServiceRepresentation connectorsItem) {
        if (this.connectors == null) {
            this.connectors = new HashMap<String, ServiceRepresentation>();
        }
        this.connectors.put(key, connectorsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, ServiceRepresentation> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Map<String, ServiceRepresentation> connectors) {
        this.connectors = connectors;
    }

    public InfrastructureRepresentation uis(Map<String, UiInfrastructureRepresentation> uis) {
        this.uis = uis;
        return this;
    }

    public InfrastructureRepresentation putUisItem(String key, UiInfrastructureRepresentation uisItem) {
        if (this.uis == null) {
            this.uis = new HashMap<String, UiInfrastructureRepresentation>();
        }
        this.uis.put(key, uisItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, UiInfrastructureRepresentation> getUis() {
        return this.uis;
    }

    public void setUis(Map<String, UiInfrastructureRepresentation> uis) {
        this.uis = uis;
    }

    public InfrastructureRepresentation bridges(Map<String, ServiceRepresentation> bridges) {
        this.bridges = bridges;
        return this;
    }

    public InfrastructureRepresentation putBridgesItem(String key, ServiceRepresentation bridgesItem) {
        if (this.bridges == null) {
            this.bridges = new HashMap<String, ServiceRepresentation>();
        }
        this.bridges.put(key, bridgesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, ServiceRepresentation> getBridges() {
        return this.bridges;
    }

    public void setBridges(Map<String, ServiceRepresentation> bridges) {
        this.bridges = bridges;
    }

    public InfrastructureRepresentation contentService(ServiceRepresentation contentService) {
        this.contentService = contentService;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ServiceRepresentation getContentService() {
        return this.contentService;
    }

    public void setContentService(ServiceRepresentation contentService) {
        this.contentService = contentService;
    }

    public InfrastructureRepresentation identityService(ServiceRepresentation identityService) {
        this.identityService = identityService;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ServiceRepresentation getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(ServiceRepresentation identityService) {
        this.identityService = identityService;
    }

    public InfrastructureRepresentation processRuntimeService(ServiceRepresentation processRuntimeService) {
        this.processRuntimeService = processRuntimeService;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ServiceRepresentation getProcessRuntimeService() {
        return this.processRuntimeService;
    }

    public void setProcessRuntimeService(ServiceRepresentation processRuntimeService) {
        this.processRuntimeService = processRuntimeService;
    }

    public InfrastructureRepresentation queryService(ServiceRepresentation queryService) {
        this.queryService = queryService;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ServiceRepresentation getQueryService() {
        return this.queryService;
    }

    public void setQueryService(ServiceRepresentation queryService) {
        this.queryService = queryService;
    }

    public InfrastructureRepresentation processStorageService(ServiceRepresentation processStorageService) {
        this.processStorageService = processStorageService;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ServiceRepresentation getProcessStorageService() {
        return this.processStorageService;
    }

    public void setProcessStorageService(ServiceRepresentation processStorageService) {
        this.processStorageService = processStorageService;
    }

    public InfrastructureRepresentation runtimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureRepresentation infrastructureRepresentation = (InfrastructureRepresentation)o;
        return Objects.equals(this.connectors, infrastructureRepresentation.connectors) && Objects.equals(this.uis, infrastructureRepresentation.uis) && Objects.equals(this.bridges, infrastructureRepresentation.bridges) && Objects.equals(this.contentService, infrastructureRepresentation.contentService) && Objects.equals(this.identityService, infrastructureRepresentation.identityService) && Objects.equals(this.processRuntimeService, infrastructureRepresentation.processRuntimeService) && Objects.equals(this.queryService, infrastructureRepresentation.queryService) && Objects.equals(this.processStorageService, infrastructureRepresentation.processStorageService) && Objects.equals(this.runtimeVersion, infrastructureRepresentation.runtimeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.connectors, this.uis, this.bridges, this.contentService, this.identityService, this.processRuntimeService, this.queryService, this.processStorageService, this.runtimeVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InfrastructureRepresentation {\n");
        sb.append("    connectors: ").append(this.toIndentedString(this.connectors)).append("\n");
        sb.append("    uis: ").append(this.toIndentedString(this.uis)).append("\n");
        sb.append("    bridges: ").append(this.toIndentedString(this.bridges)).append("\n");
        sb.append("    contentService: ").append(this.toIndentedString(this.contentService)).append("\n");
        sb.append("    identityService: ").append(this.toIndentedString(this.identityService)).append("\n");
        sb.append("    processRuntimeService: ").append(this.toIndentedString(this.processRuntimeService)).append("\n");
        sb.append("    queryService: ").append(this.toIndentedString(this.queryService)).append("\n");
        sb.append("    processStorageService: ").append(this.toIndentedString(this.processStorageService)).append("\n");
        sb.append("    runtimeVersion: ").append(this.toIndentedString(this.runtimeVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

