/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.V1ContainerStatus;
import org.alfresco.activiti.deployment.model.V1PodCondition;
import org.springframework.validation.annotation.Validated;

@Validated
public class PodHealth {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="podConditions")
    @Valid
    private List<V1PodCondition> podConditions = null;
    @JsonProperty(value="containerStatuses")
    @Valid
    private List<V1ContainerStatus> containerStatuses = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;

    public PodHealth name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PodHealth description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PodHealth podConditions(List<V1PodCondition> podConditions) {
        this.podConditions = podConditions;
        return this;
    }

    public PodHealth addPodConditionsItem(V1PodCondition podConditionsItem) {
        if (this.podConditions == null) {
            this.podConditions = new ArrayList<V1PodCondition>();
        }
        this.podConditions.add(podConditionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<V1PodCondition> getPodConditions() {
        return this.podConditions;
    }

    public void setPodConditions(List<V1PodCondition> podConditions) {
        this.podConditions = podConditions;
    }

    public PodHealth containerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
        return this;
    }

    public PodHealth addContainerStatusesItem(V1ContainerStatus containerStatusesItem) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.containerStatuses.add(containerStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<V1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses;
    }

    public void setContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    public PodHealth status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodHealth podHealth = (PodHealth)o;
        return Objects.equals(this.name, podHealth.name) && Objects.equals(this.description, podHealth.description) && Objects.equals(this.podConditions, podHealth.podConditions) && Objects.equals(this.containerStatuses, podHealth.containerStatuses) && Objects.equals((Object)this.status, (Object)podHealth.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.podConditions, this.containerStatuses, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodHealth {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    podConditions: ").append(this.toIndentedString(this.podConditions)).append("\n");
        sb.append("    containerStatuses: ").append(this.toIndentedString(this.containerStatuses)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DOWN("DOWN"),
        UNKNOWN("UNKNOWN"),
        LOADING("LOADING"),
        UP("UP");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

