/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.Quantity;
import org.alfresco.activiti.deployment.model.V1ContainerState;
import org.alfresco.activiti.deployment.model.V1ResourceRequirements;
import org.springframework.validation.annotation.Validated;

@Validated
public class V1ContainerStatus {
    @JsonProperty(value="allocatedResources")
    @Valid
    private Map<String, Quantity> allocatedResources = null;
    @JsonProperty(value="containerID")
    private String containerID = null;
    @JsonProperty(value="image")
    private String image = null;
    @JsonProperty(value="imageID")
    private String imageID = null;
    @JsonProperty(value="lastState")
    private V1ContainerState lastState = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="ready")
    private Boolean ready = null;
    @JsonProperty(value="resources")
    private V1ResourceRequirements resources = null;
    @JsonProperty(value="restartCount")
    private Integer restartCount = null;
    @JsonProperty(value="started")
    private Boolean started = null;
    @JsonProperty(value="state")
    private V1ContainerState state = null;

    public V1ContainerStatus allocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1ContainerStatus putAllocatedResourcesItem(String key, Quantity allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, Quantity>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus lastState(V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus started(Boolean started) {
        this.started = started;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public V1ContainerStatus state(V1ContainerState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(V1ContainerState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.allocatedResources, v1ContainerStatus.allocatedResources) && Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.resources, v1ContainerStatus.resources) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.started, v1ContainerStatus.started) && Objects.equals(this.state, v1ContainerStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.allocatedResources, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStatus {\n");
        sb.append("    allocatedResources: ").append(this.toIndentedString(this.allocatedResources)).append("\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

