/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.deployment.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.activiti.deployment.model.Quantity;
import org.alfresco.activiti.deployment.model.V1ResourceClaim;
import org.springframework.validation.annotation.Validated;

@Validated
public class V1ResourceRequirements {
    @JsonProperty(value="claims")
    @Valid
    private List<V1ResourceClaim> claims = null;
    @JsonProperty(value="limits")
    @Valid
    private Map<String, Quantity> limits = null;
    @JsonProperty(value="requests")
    @Valid
    private Map<String, Quantity> requests = null;

    public V1ResourceRequirements claims(List<V1ResourceClaim> claims) {
        this.claims = claims;
        return this;
    }

    public V1ResourceRequirements addClaimsItem(V1ResourceClaim claimsItem) {
        if (this.claims == null) {
            this.claims = new ArrayList<V1ResourceClaim>();
        }
        this.claims.add(claimsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<V1ResourceClaim> getClaims() {
        return this.claims;
    }

    public void setClaims(List<V1ResourceClaim> claims) {
        this.claims = claims;
    }

    public V1ResourceRequirements limits(Map<String, Quantity> limits) {
        this.limits = limits;
        return this;
    }

    public V1ResourceRequirements putLimitsItem(String key, Quantity limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Quantity>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Quantity> limits) {
        this.limits = limits;
    }

    public V1ResourceRequirements requests(Map<String, Quantity> requests) {
        this.requests = requests;
        return this;
    }

    public V1ResourceRequirements putRequestsItem(String key, Quantity requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, Quantity>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, Quantity> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRequirements v1ResourceRequirements = (V1ResourceRequirements)o;
        return Objects.equals(this.claims, v1ResourceRequirements.claims) && Objects.equals(this.limits, v1ResourceRequirements.limits) && Objects.equals(this.requests, v1ResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceRequirements {\n");
        sb.append("    claims: ").append(this.toIndentedString(this.claims)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

