/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.alfresco.transform.base.registry.AbstractTransformConfigSource;
import org.alfresco.transform.base.registry.TransformConfigFiles;
import org.alfresco.transform.base.registry.TransformConfigFilesHistoric;
import org.alfresco.transform.base.registry.TransformConfigSource;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.reader.TransformConfigResourceReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TransformConfigFromFiles {
    @Autowired
    private List<TransformConfigSource> transformConfigSources;
    @Autowired
    private TransformConfigFiles transformConfigFiles;
    @Autowired
    private TransformConfigFilesHistoric transformConfigFilesHistoric;
    @Autowired
    private TransformConfigResourceReader transformConfigResourceReader;
    @Value(value="${container.isTRouter}")
    private boolean isTRouter;

    @PostConstruct
    public void initFileConfig() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(this.transformConfigFiles.retrieveResources());
        resources.addAll(this.transformConfigFilesHistoric.retrieveResources());
        resources.forEach(resource -> {
            String filename = resource.getFilename();
            this.transformConfigSources.add(new AbstractTransformConfigSource(filename, filename, this.isTRouter ? null : "---", (Resource)resource){
                final /* synthetic */ Resource val$resource;
                {
                    this.val$resource = resource;
                    super(sortOnName, readFrom, baseUrl);
                }

                @Override
                public TransformConfig getTransformConfig() {
                    return TransformConfigFromFiles.this.transformConfigResourceReader.read(this.val$resource);
                }
            });
        });
    }

    public static List<Resource> retrieveResources(Map<String, String> additional) {
        return additional.values().stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isBlank()).map(TransformConfigFromFiles::retrieveResource).collect(Collectors.toList());
    }

    public static Resource retrieveResource(String filename) {
        FileSystemResource resource = new FileSystemResource(filename);
        if (resource.exists()) {
            return resource;
        }
        return new ClassPathResource(filename);
    }
}

