/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.TransformController;
import org.alfresco.transform.base.TransformControllerTest;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithAllInOne;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithOneCustomTransformer;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithTwoCustomTransformers;
import org.alfresco.transform.base.fakes.FakeTransformerPdf2Jpg;
import org.alfresco.transform.base.fakes.FakeTransformerPdf2Png;
import org.alfresco.transform.base.fakes.FakeTransformerTxT2Pdf;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@AutoConfigureMockMvc
@SpringBootTest(classes={Application.class})
@ContextConfiguration(classes={FakeTransformEngineWithAllInOne.class, FakeTransformEngineWithTwoCustomTransformers.class, FakeTransformerTxT2Pdf.class, FakeTransformerPdf2Png.class, FakeTransformEngineWithOneCustomTransformer.class, FakeTransformerPdf2Jpg.class})
public class TransformControllerAllInOneTest {
    @Autowired
    private MockMvc mockMvc;
    @Autowired
    private TransformController transformController;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    private String coreVersion;

    @Test
    public void testInitEngine() {
        Assertions.assertEquals((Object)FakeTransformEngineWithAllInOne.class.getSimpleName(), (Object)this.transformController.transformEngine.getClass().getSimpleName());
    }

    @Test
    public void testStartupLogsIncludeEngineMessages() {
        StringJoiner controllerLogMessages = TransformControllerTest.getLogMessagesFor(TransformController.class);
        this.transformController.startup();
        Assertions.assertEquals((Object)"--------------------------------------------------------------------------------------------------------------------------------------------------------------\nStartup 0000 AllInOne\nLine 2 0000 AllInOne\nLine 3\n--------------------------------------------------------------------------------------------------------------------------------------------------------------\nStarting application components... Done", (Object)controllerLogMessages.toString());
    }

    @Test
    public void testVersionEndpointIncludesAvailable() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/version", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("AllInOne " + this.coreVersion));
    }

    @Test
    public void testRootEndpointReturnsTestPage() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"AllInOne Test Page")));
    }

    @Test
    public void testErrorEndpointReturnsErrorPage() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"AllInOne Error Page")));
    }

    @Test
    public void testLogEndpointReturnsLogPage() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/log", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"AllInOne Log Entries")));
    }

    @Test
    public void testReadyEndpointReturnsSuccessful() throws Exception {
        TransformControllerTest.resetProbeForTesting(this.transformController);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/ready", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"Success - ")));
    }

    @Test
    public void testLiveEndpointReturnsSuccessful() throws Exception {
        TransformControllerTest.resetProbeForTesting(this.transformController);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/live", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"Success - ")));
    }

    @Test
    public void testConfigEndpointReturnsOriginalConfigFormat() throws Exception {
        TransformControllerTest.assertConfig("/transform/config", "Pdf2Jpg,null,imageOptions\nPdf2Png,null,imageOptions\nTxT2Pdf,null,docOptions\nTxt2JpgViaPdf,null,imageOptions\nTxt2PngViaPdf,null,imageOptions", "docOptions,imageOptions", this.mockMvc, this.objectMapper);
    }

    @Test
    public void testConfigLatestEndpointReturnsCoreVersionAndDirectAccessUrlOption() throws Exception {
        TransformControllerTest.assertConfig("/transform/config?configVersion=2", "Pdf2Jpg," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename\nPdf2Png," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename\nTxT2Pdf," + this.coreVersion + ",directAccessUrl,docOptions,sourceFilename\nTxt2JpgViaPdf," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename\nTxt2PngViaPdf," + this.coreVersion + ",directAccessUrl,imageOptions,sourceFilename", "directAccessUrl,docOptions,imageOptions,sourceFilename", this.mockMvc, this.objectMapper);
    }

    @Test
    public void testTransformEndpointUsingTransformEngineWithTwoCustomTransformers() throws Exception {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8))).param("sourceMimetype", new String[]{"text/plain"}).param("targetMimetype", new String[]{"application/pdf"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform.pdf")).andExpect(MockMvcResultMatchers.content().string("Start -> TxT2Pdf(page=1)")));
    }

    @Test
    public void testTransformEndpointUsingTransformEngineWithOneCustomTransformer() throws Exception {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "application/pdf", "Start".getBytes(StandardCharsets.UTF_8))).param("sourceMimetype", new String[]{"application/pdf"}).param("targetMimetype", new String[]{"image/jpeg"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform.jpeg")).andExpect(MockMvcResultMatchers.content().string("Start -> Pdf2Jpg()")));
    }
}

