/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.clients;

import java.util.Collections;
import java.util.Map;
import org.alfresco.transform.base.MtlsTestUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClient {
    private static final RestTemplate REST_TEMPLATE = MtlsTestUtils.getRestTemplate();

    public static ResponseEntity<Resource> sendTRequest(String engineUrl, String sourceFile, String sourceMimetype, String targetMimetype, String targetExtension) {
        return HttpClient.sendTRequest(engineUrl, sourceFile, sourceMimetype, targetMimetype, targetExtension, Collections.emptyMap());
    }

    public static ResponseEntity<Resource> sendTRequest(String engineUrl, String sourceFile, String sourceMimetype, String targetMimetype, String targetExtension, Map<String, String> transformOptions) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)new ClassPathResource(sourceFile));
        if (sourceMimetype != null && !sourceMimetype.trim().isEmpty()) {
            body.add((Object)"sourceMimetype", (Object)sourceMimetype);
        }
        if (targetMimetype != null && !targetMimetype.trim().isEmpty()) {
            body.add((Object)"targetMimetype", (Object)targetMimetype);
        }
        if (targetExtension != null && !targetExtension.trim().isEmpty()) {
            body.add((Object)"targetExtension", (Object)targetExtension);
        }
        transformOptions.forEach((arg_0, arg_1) -> ((MultiValueMap)body).add(arg_0, arg_1));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        return REST_TEMPLATE.postForEntity(engineUrl + "/transform", (Object)entity, Resource.class, new Object[0]);
    }
}

