/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.fakes;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.TransformManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.TestComponent;

@TestComponent
public abstract class AbstractFakeTransformer
implements CustomTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getTransformerName() {
        String simpleClassName = this.getClass().getSimpleName();
        return simpleClassName.substring("FakeTransformer".length());
    }

    public void transform(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        String oldValue = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        String newValue = oldValue + " -> " + this.getTransformerName() + "(" + transformOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ")) + ')';
        this.logger.info(newValue);
        byte[] bytes = newValue.getBytes(StandardCharsets.UTF_8);
        outputStream.write(bytes, 0, bytes.length);
    }
}

