/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.transform.StreamHandler;
import org.alfresco.transform.base.transform.TransformManagerImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class StreamHandlerTest {
    public static final String ORIGINAL = "Original";
    public static final String CHANGE = " plus some change";
    public static final String EXPECTED = "Original plus some change";
    TransformManagerImpl transformManager = new TransformManagerImpl();
    @TempDir
    public File tempDir;

    private InputStream getSourceInputStreamFromBytes() {
        return new ByteArrayInputStream(ORIGINAL.getBytes(StandardCharsets.ISO_8859_1));
    }

    private OutputStream getOutputStreamToFile(File sourceFile) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(sourceFile));
    }

    private InputStream getInputStreamFromFile(File sourceFile) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(sourceFile));
    }

    private File tempFile() throws IOException {
        return File.createTempFile("temp_", null, this.tempDir);
    }

    private static void write(File file, String text) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
            StreamHandlerTest.write(outputStream, text);
        }
    }

    private static void write(OutputStream outputStream, String text) throws IOException {
        byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
        outputStream.write(bytes, 0, bytes.length);
    }

    public static String read(File file) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            String string = StreamHandlerTest.read(inputStream);
            return string;
        }
    }

    private static String read(InputStream inputStream) throws IOException {
        return new String(inputStream.readAllBytes(), StandardCharsets.ISO_8859_1);
    }

    private static String read(ByteArrayOutputStream outputStream) {
        return outputStream.toString(StandardCharsets.ISO_8859_1);
    }

    private void closeInputStreamWithoutException(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testStartWithInputStream() throws Exception {
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.transformManager.setInputStream(inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(inputStream);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(outputStream));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
        }
    }

    @Test
    public void testStartWithInputStreamAndCallCreateSourceFile() throws Exception {
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.transformManager.setInputStream(inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            File sourceFileCreatedByTransform = this.transformManager.createSourceFile();
            Assertions.assertTrue((boolean)sourceFileCreatedByTransform.exists());
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(sourceFileCreatedByTransform) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(inputStream);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(outputStream));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)sourceFileCreatedByTransform.exists());
        }
    }

    @Test
    public void testStartWithSourceFile() throws Exception {
        File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        this.transformManager.setSourceFile(sourceFile);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.transformManager.setInputStream((InputStream)inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.closeInputStreamWithoutException(inputStream);
            this.transformManager.getOutputStream().close();
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(outputStream));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)sourceFile.exists());
        }
    }

    @Test
    public void testStartWithSourceFileAndCallCreateSourceFile() throws Exception {
        File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        this.transformManager.setSourceFile(sourceFile);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.transformManager.setInputStream((InputStream)inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            File sourceFileCreatedByTransform = this.transformManager.createSourceFile();
            Assertions.assertEquals((Object)sourceFile, (Object)sourceFileCreatedByTransform);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(sourceFileCreatedByTransform) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.closeInputStreamWithoutException(inputStream);
            this.transformManager.getOutputStream().close();
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(outputStream));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)sourceFile.exists());
        }
    }

    @Test
    public void testStartWithOutputStream() {
    }

    @Test
    public void testStartWithOutputStreamAndCallCreateTargetFile() throws Exception {
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.transformManager.setInputStream(inputStream);
            this.transformManager.setOutputStream((OutputStream)outputStream);
            File targetFileCreatedByTransform = this.transformManager.createTargetFile();
            Assertions.assertTrue((boolean)targetFileCreatedByTransform.exists());
            StreamHandlerTest.write(targetFileCreatedByTransform, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(inputStream);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(outputStream));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)targetFileCreatedByTransform.exists());
        }
    }

    @Test
    public void testStartWithTargetFile() throws Exception {
        File targetFile = this.tempFile();
        this.transformManager.setTargetFile(targetFile);
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));){
            this.transformManager.setInputStream(inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(inputStream);
            String actual = StreamHandlerTest.read(targetFile);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)actual);
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)targetFile.exists());
        }
    }

    @Test
    public void testStartWithTargetFileAndCallCreateTargetFile() throws Exception {
        File targetFile = this.tempFile();
        this.transformManager.setTargetFile(targetFile);
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));){
            this.transformManager.setInputStream(inputStream);
            this.transformManager.setOutputStream((OutputStream)outputStream);
            File targetFileCreatedByTransform = this.transformManager.createTargetFile();
            Assertions.assertEquals((Object)targetFile, (Object)targetFileCreatedByTransform);
            StreamHandlerTest.write(targetFileCreatedByTransform, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(inputStream);
            String actual = StreamHandlerTest.read(targetFile);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)actual);
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)targetFile.exists());
        }
    }

    @Test
    public void testHandleHttpRequestApproachUsingSourceAndTargetStreams() {
    }

    @Test
    public void testHandleProbeRequestApproachUsingSourceAndTargetFilesButKeepingTheTarget() throws Exception {
        File targetFile = this.tempFile();
        File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        this.transformManager.setSourceFile(sourceFile);
        this.transformManager.keepTargetFile();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));){
            this.transformManager.setInputStream((InputStream)inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.closeInputStreamWithoutException(inputStream);
            this.transformManager.getOutputStream().close();
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(targetFile));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)sourceFile.exists());
            Assertions.assertTrue((boolean)targetFile.exists());
        }
    }

    @Test
    public void testHandleMessageRequestApproachUsingSourceAndTargetFiles() throws Exception {
        File targetFile = this.tempFile();
        File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        this.transformManager.setSourceFile(sourceFile);
        this.transformManager.setTargetFile(targetFile);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));){
            this.transformManager.setInputStream((InputStream)inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.closeInputStreamWithoutException(inputStream);
            this.transformManager.getOutputStream().close();
            String actual = StreamHandlerTest.read(targetFile);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)actual);
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)sourceFile.exists());
            Assertions.assertFalse((boolean)targetFile.exists());
        }
    }

    @Test
    public void testHandleMessageRequestApproachUsingInputStreamAndTargetFile() throws Exception {
        File targetFile = this.tempFile();
        this.transformManager.setTargetFile(targetFile);
        try (InputStream inputStream = this.getSourceInputStreamFromBytes();
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));){
            this.transformManager.setInputStream(inputStream);
            OutputStream outputStreamLengthRecorder = this.transformManager.setOutputStream((OutputStream)outputStream);
            StreamHandlerTest.write(outputStreamLengthRecorder, StreamHandlerTest.read(inputStream) + CHANGE);
            this.transformManager.copyTargetFileToOutputStream();
            this.closeInputStreamWithoutException(inputStream);
            this.transformManager.getOutputStream().close();
            String actual = StreamHandlerTest.read(targetFile);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)actual);
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)targetFile.exists());
        }
    }

    @Test
    public void testSimulatedHandleHttpRequest() throws Exception {
        final File targetFile = this.tempFile();
        try (final ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new FakeStreamHandler(){

                protected void init() throws IOException {
                    this.transformManager.setTargetFile(targetFile);
                    this.transformManager.keepTargetFile();
                    super.init();
                }

                protected InputStream getInputStream() {
                    return StreamHandlerTest.this.getSourceInputStreamFromBytes();
                }

                protected OutputStream getOutputStream() {
                    return os;
                }
            }.handleTransformRequest();
        }
    }

    @Test
    public void testSimulatedHandleProbeRequest() throws Exception {
        final File targetFile = this.tempFile();
        final File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        new FakeStreamHandler(){

            protected void init() throws IOException {
                this.transformManager.setSourceFile(sourceFile);
                this.transformManager.setTargetFile(targetFile);
                this.transformManager.keepTargetFile();
                super.init();
            }

            protected InputStream getInputStream() throws IOException {
                return StreamHandlerTest.this.getInputStreamFromFile(sourceFile);
            }

            protected OutputStream getOutputStream() throws IOException {
                return StreamHandlerTest.this.getOutputStreamToFile(targetFile);
            }
        }.handleTransformRequest();
    }

    @Test
    public void testSimulatedHandleMessageRequestUsingSharedFileStore() throws Exception {
        final File targetFile = this.tempFile();
        final File sourceFile = this.tempFile();
        StreamHandlerTest.write(sourceFile, ORIGINAL);
        new FakeStreamHandler(){

            protected InputStream getInputStream() throws IOException {
                return StreamHandlerTest.this.getInputStreamFromFile(sourceFile);
            }

            protected OutputStream getOutputStream() throws IOException {
                return StreamHandlerTest.this.getOutputStreamToFile(targetFile);
            }
        }.handleTransformRequest();
    }

    @Test
    public void testSimulatedHandleMessageRequestUsingDirectAccessUrl() throws Exception {
        final File targetFile = this.tempFile();
        new FakeStreamHandler(){

            protected InputStream getInputStream() {
                return StreamHandlerTest.this.getSourceInputStreamFromBytes();
            }

            protected OutputStream getOutputStream() throws FileNotFoundException {
                return StreamHandlerTest.this.getOutputStreamToFile(targetFile);
            }
        }.handleTransformRequest();
    }

    @Test
    public void testSimulatedHandleHttpRequestWithStreamingResponseBody() throws Exception {
        try (final ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new FakeStreamHandler(){

                protected InputStream getInputStream() {
                    return StreamHandlerTest.this.getSourceInputStreamFromBytes();
                }

                protected OutputStream getOutputStream() {
                    return os;
                }
            }.handleTransformRequest();
        }
    }

    @Test
    public void testStartWithInputStreamAndCallCreateSourceFileWithSourceFileName() throws Exception {
        try (InputStream in = this.getSourceInputStreamFromBytes();
             ByteArrayOutputStream out = new ByteArrayOutputStream();
             OutputStream rec = this.transformManager.setOutputStream((OutputStream)out);){
            String testFilename = "test.docx";
            this.transformManager.setSourceFileName(testFilename);
            this.transformManager.setInputStream(in);
            File src = this.transformManager.createSourceFile();
            Assertions.assertTrue((boolean)src.exists());
            StreamHandlerTest.write(rec, StreamHandlerTest.read(src) + CHANGE);
            Assertions.assertEquals((Object)testFilename, (Object)src.getName());
            this.transformManager.copyTargetFileToOutputStream();
            this.transformManager.getOutputStream().close();
            this.closeInputStreamWithoutException(in);
            Long outputLength = this.transformManager.getOutputLength();
            this.transformManager.deleteSourceFile();
            this.transformManager.deleteTargetFile();
            Assertions.assertEquals((Object)EXPECTED, (Object)StreamHandlerTest.read(out));
            Assertions.assertEquals((long)EXPECTED.length(), (Long)outputLength);
            Assertions.assertFalse((boolean)src.exists());
        }
    }

    private abstract class FakeStreamHandler
    extends StreamHandler {
        private FakeStreamHandler() {
        }

        public void handleTransformRequest() throws Exception {
            this.init();
            this.handleTransform(null);
        }

        protected void transform(CustomTransformer customTransformer) throws Exception {
            StreamHandlerTest.write(this.outputStream, StreamHandlerTest.read(this.inputStream) + StreamHandlerTest.CHANGE);
        }
    }
}

