/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import org.alfresco.transform.base.WebClientBuilderAdjuster;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.web.client.RestTemplate;

@Configuration
public class MTLSConfig {
    @Value(value="${client.ssl.key-store:#{null}}")
    private Resource keyStoreResource;
    @Value(value="${client.ssl.key-store-password:}")
    private char[] keyStorePassword;
    @Value(value="${client.ssl.key-store-type:}")
    private String keyStoreType;
    @Value(value="${client.ssl.trust-store:#{null}}")
    private Resource trustStoreResource;
    @Value(value="${client.ssl.trust-store-password:}")
    private char[] trustStorePassword;
    @Value(value="${client.ssl.trust-store-type:}")
    private String trustStoreType;
    @Value(value="${client.ssl.hostname-verification-disabled:false}")
    private boolean hostNameVerificationDisabled;

    @Bean
    public WebClientBuilderAdjuster webClientBuilderAdjuster(SslContextFactory.Client sslContextFactory) {
        return builder -> {
            if (this.isTlsOrMtlsConfigured()) {
                ClientConnector clientConnector = new ClientConnector();
                clientConnector.setSslContextFactory(sslContextFactory);
                HttpClient httpClientWithSslContext = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
                builder.clientConnector((ClientHttpConnector)new JettyClientHttpConnector(httpClientWithSslContext));
            }
        };
    }

    @Bean
    public RestTemplate restTemplate(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        if (this.isTlsOrMtlsConfigured()) {
            return this.createRestTemplateWithSslContext(sslContextBuilder);
        }
        return new RestTemplate();
    }

    @Bean
    public SSLContextBuilder sslContextBuilder() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        if (this.isKeystoreConfigured()) {
            KeyStore keyStore = this.getKeyStore(this.keyStoreType, this.keyStoreResource, this.keyStorePassword);
            sslContextBuilder.loadKeyMaterial(keyStore, this.keyStorePassword);
        }
        if (this.isTruststoreConfigured()) {
            sslContextBuilder.setKeyStoreType(this.trustStoreType).loadTrustMaterial(this.trustStoreResource.getURL(), this.trustStorePassword);
        }
        return sslContextBuilder;
    }

    @Bean
    public SslContextFactory.Client sslContextFactory(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setSslContext(sslContextBuilder.build());
        sslContextFactory.setTrustAll(false);
        sslContextFactory.setEndpointIdentificationAlgorithm(this.hostNameVerificationDisabled ? "" : "HTTPS");
        sslContextFactory.setIncludeProtocols(new String[]{TLS.V_1_2.getId(), TLS.V_1_3.getId()});
        return sslContextFactory;
    }

    private boolean isTlsOrMtlsConfigured() {
        return this.isTruststoreConfigured() || this.isKeystoreConfigured();
    }

    private boolean isTruststoreConfigured() {
        return this.trustStoreResource != null;
    }

    private boolean isKeystoreConfigured() {
        return this.keyStoreResource != null;
    }

    private RestTemplate createRestTemplateWithSslContext(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContextBuilder.build()).setTlsVersions(new TLS[]{TLS.V_1_2, TLS.V_1_3});
        if (this.hostNameVerificationDisabled) {
            sslConnectionSocketFactoryBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = sslConnectionSocketFactoryBuilder.build();
        Registry sslSocketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager sslConnectionManager = new PoolingHttpClientConnectionManager(sslSocketFactoryRegistry);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)sslConnectionManager);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((org.apache.hc.client5.http.classic.HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private KeyStore getKeyStore(String keyStoreType, Resource keyStoreResource, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream keyStoreInputStream = keyStoreResource.getInputStream();){
            keyStore.load(keyStoreInputStream, keyStorePassword);
        }
        return keyStore;
    }
}

