/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.clients;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class JacksonSerializer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> byte[] serialize(T value) throws Exception {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);){
            byte[] byArray;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                MAPPER.writer().writeValue((Writer)writer, value);
                byArray = stream.toByteArray();
            }
            return byArray;
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) throws Exception {
        return (T)MAPPER.readValue(data, cls);
    }

    public static <T> T deserialize(byte[] data, int len, Class<T> cls) throws Exception {
        return (T)MAPPER.readValue(data, 0, len, cls);
    }

    public static String readStringValue(String json, String key) throws Exception {
        JsonNode node = MAPPER.readTree(json);
        for (String k : key.split("\\.")) {
            node = node.get(k);
        }
        return node.asText();
    }

    static {
        MAPPER.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

