/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.fs.FileManager;
import org.alfresco.transform.base.transform.ProcessHandler;
import org.alfresco.transform.base.util.OutputStreamLengthRecorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransformManagerImpl
implements TransformManager {
    private static final Logger logger = LoggerFactory.getLogger(TransformManagerImpl.class);
    private HttpServletRequest request;
    private ProcessHandler processHandler;
    private InputStream inputStream;
    private OutputStreamLengthRecorder outputStreamLengthRecorder;
    private String sourceMimetype;
    private String targetMimetype;
    private File sourceFile;
    private File targetFile;
    private boolean keepTargetFile;
    private boolean createSourceFileCalled;
    private boolean createTargetFileCalled;
    private Boolean startedWithSourceFile;
    private Boolean startedWithTargetFile;
    private String sourceFileName;

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    @Override
    public String getRequestId() {
        return this.processHandler.getReference();
    }

    public InputStream setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        if (this.startedWithSourceFile == null) {
            this.startedWithSourceFile = false;
        }
        return inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStreamLengthRecorder;
    }

    public OutputStream setOutputStream(OutputStream outputStream) {
        this.outputStreamLengthRecorder = new OutputStreamLengthRecorder(outputStream);
        if (this.startedWithTargetFile == null) {
            this.startedWithTargetFile = false;
        }
        return this.outputStreamLengthRecorder;
    }

    public Long getOutputLength() {
        return this.outputStreamLengthRecorder.getLength();
    }

    public void setSourceMimetype(String sourceMimetype) {
        this.sourceMimetype = sourceMimetype;
    }

    public void setTargetMimetype(String targetMimetype) {
        this.targetMimetype = targetMimetype;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
        if (this.startedWithSourceFile == null) {
            this.startedWithSourceFile = true;
        }
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
        if (this.startedWithTargetFile == null) {
            this.startedWithTargetFile = true;
        }
    }

    public void keepTargetFile() {
        this.keepTargetFile = true;
    }

    @Override
    public File createSourceFile() {
        if (this.createSourceFileCalled) {
            throw new IllegalStateException("createSourceFile has already been called");
        }
        this.createSourceFileCalled = true;
        if (this.sourceFile == null) {
            this.sourceFile = FileManager.createSourceFile(this.request, this.inputStream, this.sourceMimetype, this.sourceFileName);
        }
        return this.sourceFile;
    }

    @Override
    public File createTargetFile() {
        if (this.createTargetFileCalled) {
            throw new IllegalStateException("createTargetFile has already been called");
        }
        this.createTargetFileCalled = true;
        if (this.targetFile == null) {
            this.targetFile = FileManager.createTargetFile(this.request, this.sourceMimetype, this.targetMimetype);
        }
        return this.targetFile;
    }

    public void copyTargetFileToOutputStream() throws IOException {
        if (this.targetFile != null) {
            if (!this.startedWithTargetFile.booleanValue()) {
                FileManager.copyFileToOutputStream(this.targetFile, this.outputStreamLengthRecorder);
            } else if (this.createTargetFileCalled) {
                this.outputStreamLengthRecorder.setByteCount(this.targetFile.length());
            } else {
                this.outputStreamLengthRecorder.flush();
            }
        }
    }

    public void deleteSourceFile() {
        File parentDir;
        if (this.sourceFile != null && !this.sourceFile.delete()) {
            logger.error("Failed to delete temporary source file {}", (Object)this.sourceFile.getPath());
        }
        if (this.sourceFile != null && (parentDir = this.sourceFile.getParentFile()) != null && !StringUtils.equalsAny((CharSequence)parentDir.getName().toLowerCase(Locale.ROOT), (CharSequence[])new CharSequence[]{"alfresco", "temp", "tmp"}) && !parentDir.delete()) {
            logger.error("Failed to delete parent directory {}", (Object)parentDir.getPath());
        }
        this.outputStreamLengthRecorder = null;
        this.sourceFile = null;
        this.sourceFileName = null;
        this.createSourceFileCalled = false;
        this.startedWithSourceFile = null;
    }

    public void deleteTargetFile() {
        if (!this.keepTargetFile && this.targetFile != null && !this.targetFile.delete()) {
            logger.error("Failed to delete temporary target file {}", (Object)this.targetFile.getPath());
        }
        this.targetFile = null;
        this.createTargetFileCalled = false;
        this.startedWithTargetFile = null;
    }

    @Override
    public OutputStream respondWithFragment(Integer index, boolean finished) throws IOException {
        if (this.request != null) {
            throw new IllegalStateException("Fragments may only be sent via message queues. This an http request");
        }
        return this.processHandler.respondWithFragment(index, finished);
    }
}

