/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.clients;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import org.alfresco.transform.base.MtlsTestUtils;
import org.alfresco.transform.base.clients.JacksonSerializer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.LoggerFactory;

public class SfsClient {
    private static final String SFS_BASE_URL;

    public static String uploadFile(String fileToUploadName) throws Exception {
        return SfsClient.uploadFile(fileToUploadName, SFS_BASE_URL);
    }

    public static String uploadFile(String fileToUploadName, String sfsBaseUrl) throws Exception {
        File file = SfsClient.readFile(fileToUploadName);
        HttpPost post = new HttpPost(sfsBaseUrl + "/alfresco/api/-default-/private/sfs/versions/1/file");
        post.setEntity(MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).addPart("file", (ContentBody)new FileBody(file, ContentType.DEFAULT_BINARY)).build());
        try (CloseableHttpClient client = MtlsTestUtils.getHttpClient();){
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)post);
            int status = response.getCode();
            if (status >= 200 && status < 300) {
                String string = JacksonSerializer.readStringValue(EntityUtils.toString((HttpEntity)((HttpEntityContainer)response).getEntity()), "entry.fileRef");
                return string;
            }
            throw new Exception("Failed to upload source file to SFS");
        }
    }

    private static File readFile(String filename) throws Exception {
        URL url = SfsClient.class.getClassLoader().getResource(filename);
        if (url == null) {
            throw new Exception("Failed to load resource URL with filename " + filename);
        }
        URI uri = url.toURI();
        try {
            return Paths.get(uri).toFile();
        }
        catch (Exception e) {
            return SfsClient.readFileFromJar(uri);
        }
    }

    private static File readFileFromJar(URI uri) throws Exception {
        String[] array = uri.toString().split("!");
        try (FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), ImmutableMap.of((Object)"create", (Object)"true"));){
            File temp = File.createTempFile("temp-", "", new File(System.getProperty("user.dir")));
            temp.deleteOnExit();
            Files.copy(fs.getPath(array[1], new String[0]), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            temp.deleteOnExit();
            File file = temp;
            return file;
        }
    }

    public static boolean checkFile(String uuid) throws Exception {
        return SfsClient.checkFile(uuid, SFS_BASE_URL);
    }

    public static boolean checkFile(String uuid, String sfsBaseUrl) throws Exception {
        HttpHead head = new HttpHead(MessageFormat.format(sfsBaseUrl + "/alfresco/api/-default-/private/sfs/versions/1/file/{0}", uuid));
        try (CloseableHttpClient client = MtlsTestUtils.getHttpClient();){
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)head);
            int status = response.getCode();
            boolean bl = status >= 200 && status < 300;
            return bl;
        }
    }

    public static File downloadFile(String uuid) throws Exception {
        return SfsClient.downloadFile(uuid, SFS_BASE_URL);
    }

    public static File downloadFile(String uuid, String sfsBaseUrl) throws Exception {
        HttpGet get = new HttpGet(MessageFormat.format(sfsBaseUrl + "/alfresco/api/-default-/private/sfs/versions/1/file/{0}", uuid));
        try (CloseableHttpClient client = MtlsTestUtils.getHttpClient();){
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)get);
            int status = response.getCode();
            if (status < 200 || status >= 300) {
                throw new Exception("File with UUID " + uuid + " was not found on SFS");
            }
            HttpEntity entity = ((HttpEntityContainer)response).getEntity();
            if (entity == null) {
                throw new Exception("Failed to read HTTP reply entity for file with UUID " + uuid);
            }
            File file = File.createTempFile(uuid, "_tmp", new File(System.getProperty("user.dir")));
            file.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(file);){
                entity.writeTo((OutputStream)os);
            }
            File file2 = file;
            return file2;
        }
    }

    static {
        ((Logger)LoggerFactory.getLogger((String)"org.apache.http.client.protocol")).setLevel(Level.INFO);
        ((Logger)LoggerFactory.getLogger((String)"org.apache.http.impl.conn")).setLevel(Level.INFO);
        ((Logger)LoggerFactory.getLogger((String)"org.apache.http.headers")).setLevel(Level.INFO);
        ((Logger)LoggerFactory.getLogger((String)"org.apache.http.wire")).setLevel(Level.INFO);
        ((Logger)LoggerFactory.getLogger((String)"org.apache.http.wire")).setAdditive(false);
        SFS_BASE_URL = MtlsTestUtils.isMtlsEnabled() ? "https://localhost:8099" : "http://localhost:8099";
    }
}

