/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.base.html.OptionsHelper;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionsHelperTest {
    @Test
    public void emptyTest() {
        Map transformOptionsByName = Collections.emptyMap();
        Assertions.assertEquals(Collections.emptySet(), (Object)OptionsHelper.getOptionNames(transformOptionsByName));
    }

    @Test
    public void singleOptionNameWithSingleValue() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"Dummy", (Object)ImmutableSet.of((Object)new TransformOptionValue(true, "startPage")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage"), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void whenOptionNameEndsInOptions_stripIt() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(true, "startPage")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage"), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void singleOptionNameWithASingleRequiredValue() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(true, "startPage")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage"), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void singleOptionNameWithACoupleOfValues() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "startPage"), (Object)new TransformOptionValue(true, "endPage")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage", (Object)"endPage"), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void sortedValues() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "a"), (Object)new TransformOptionValue(false, "n"), (Object)new TransformOptionValue(false, "k"), (Object)new TransformOptionValue(false, "f"), (Object)new TransformOptionValue(true, "z")));
        Assertions.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"f", (Object)"k", (Object)"n", (Object)"z"), new ArrayList(OptionsHelper.getOptionNames((Map)transformOptionsByName)));
    }

    @Test
    public void multipleOptionNames() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "startPage"), (Object)new TransformOptionValue(true, "endPage")), (Object)"Another", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "scale")), (Object)"YetAnother", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "x"), (Object)new TransformOptionValue(false, "y"), (Object)new TransformOptionValue(true, "ratio")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage", (Object)"endPage", (Object)"scale", (Object)"x", (Object)"y", (Object)"ratio", (Object[])new String[0]), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void multipleOptionNamesWithDuplicates() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "startPage"), (Object)new TransformOptionValue(true, "endPage")), (Object)"Another", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "scale")), (Object)"YetAnother", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "x"), (Object)new TransformOptionValue(false, "y"), (Object)new TransformOptionValue(true, "scale")));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"startPage", (Object)"endPage", (Object)"scale", (Object)"x", (Object)"y"), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }

    @Test
    public void nestedGroups() {
        ImmutableMap transformOptionsByName = ImmutableMap.of((Object)"DummyOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "1"), (Object)new TransformOptionValue(true, "2"), (Object)new TransformOptionGroup(false, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "3.1"), (Object)new TransformOptionValue(true, "3.2"), (Object)new TransformOptionValue(false, "3.3"))), (Object)new TransformOptionGroup(true, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "4.1"), (Object)new TransformOptionGroup(false, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "4.2.1"), (Object)new TransformOptionGroup(true, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "4.2.2.1"))), (Object)new TransformOptionValue(true, "4.2.3"))), (Object)new TransformOptionValue(false, "4.3")))));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"1", (Object)"2", (Object)"3.1", (Object)"3.2", (Object)"3.3", (Object)"4.1", (Object[])new String[]{"4.2.1", "4.2.2.1", "4.2.3", "4.3"}), (Object)OptionsHelper.getOptionNames((Map)transformOptionsByName));
    }
}

