/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.fs;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.alfresco.transform.base.logging.LogEntry;
import org.alfresco.transform.common.ExtensionService;
import org.alfresco.transform.exceptions.TransformException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

public class FileManager {
    public static final String SOURCE_FILE = "sourceFile";
    public static final String TARGET_FILE = "targetFile";

    private FileManager() {
    }

    public static File createSourceFile(HttpServletRequest request, InputStream inputStream, String sourceMimetype, String sourceFileName) {
        try {
            String extension = "." + ExtensionService.getExtensionForMimetype((String)sourceMimetype);
            File file = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sourceFileName) ? TempFileProvider.createTempFile("source_", extension) : TempFileProvider.createFileWithinUUIDTempDir(sourceFileName);
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (request != null) {
                request.setAttribute(SOURCE_FILE, (Object)file);
            }
            LogEntry.setSource(file.getName(), file.length());
            return file;
        }
        catch (Exception e) {
            throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, "Failed to store the source file", (Throwable)e);
        }
    }

    public static File createTargetFile(HttpServletRequest request, String sourceMimetype, String targetMimetype) {
        try {
            String extension = "." + ExtensionService.getExtensionForTargetMimetype((String)targetMimetype, (String)sourceMimetype);
            File file = TempFileProvider.createTempFile("target_", extension);
            if (request != null) {
                request.setAttribute(TARGET_FILE, (Object)file);
            }
            LogEntry.setTarget(file.getName());
            return file;
        }
        catch (Exception e) {
            throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, "Failed to create the target file", (Throwable)e);
        }
    }

    public static void deleteFile(File file) throws Exception {
        if (!file.delete()) {
            throw new Exception("Failed to delete file");
        }
    }

    private static Resource load(File file) {
        try {
            UrlResource resource = new UrlResource(file.toURI());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Could not read the target file: " + file.getPath());
        }
        catch (MalformedURLException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "The target filename was malformed: " + file.getPath(), (Throwable)e);
        }
    }

    public static InputStream getMultipartFileInputStream(MultipartFile sourceMultipartFile) {
        InputStream inputStream;
        if (sourceMultipartFile == null) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Required request part 'file' is not present");
        }
        try {
            inputStream = sourceMultipartFile.getInputStream();
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Unable to read the sourceMultipartFile.", (Throwable)e);
        }
        return inputStream;
    }

    public static InputStream getDirectAccessUrlInputStream(String directUrl) {
        try {
            return new URL(directUrl).openStream();
        }
        catch (IllegalArgumentException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Direct Access Url is invalid.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, "Direct Access Url not found.", (Throwable)e);
        }
    }

    public static void copyFileToOutputStream(File targetFile, OutputStream outputStream) {
        try {
            Files.copy(targetFile.toPath(), outputStream);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Failed to copy targetFile to outputStream.", (Throwable)e);
        }
    }

    public static void deleteFile(HttpServletRequest request, String attributeName) {
        File file = (File)request.getAttribute(attributeName);
        if (file != null) {
            file.delete();
        }
    }

    public static ResponseEntity<Resource> createAttachment(String targetFilename, File targetFile) {
        Resource targetResource = FileManager.load(targetFile);
        targetFilename = UriUtils.encodePath((String)StringUtils.getFilename((String)targetFilename), (String)"UTF-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename*=UTF-8''" + targetFilename})).body((Object)targetResource);
    }

    public static class TempFileProvider {
        private TempFileProvider() {
        }

        public static File createTempFile(String prefix, String suffix) {
            File directory = TempFileProvider.getTempDir();
            try {
                return File.createTempFile(prefix, suffix, directory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to created temp file: \n   prefix: " + prefix + "\n   suffix: " + suffix + "\n   directory: " + String.valueOf(directory), e);
            }
        }

        public static File createFileWithinUUIDTempDir(String sourceFileName) {
            File tempDir = new File(TempFileProvider.getTempDir(), UUID.randomUUID().toString());
            if (!tempDir.mkdirs() && !tempDir.exists()) {
                throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, "Failed to create temp directory: " + String.valueOf(tempDir));
            }
            return new File(tempDir, sourceFileName);
        }

        private static File getTempDir() {
            String dirName = "Alfresco";
            String systemTempDirPath = System.getProperty("java.io.tmpdir");
            if (systemTempDirPath == null) {
                throw new RuntimeException("System property not available: java.io.tmpdir");
            }
            File systemTempDir = new File(systemTempDirPath);
            File tempDir = new File(systemTempDir, "Alfresco");
            if (!(tempDir.exists() || tempDir.mkdirs() || tempDir.exists())) {
                throw new RuntimeException("Failed to create temp directory: " + String.valueOf(tempDir));
            }
            return tempDir;
        }
    }
}

