/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.TransformController;
import org.alfresco.transform.base.executors.CommandExecutor;
import org.alfresco.transform.base.executors.RuntimeExec;
import org.alfresco.transform.base.model.FileRefEntity;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.sfs.SharedFileStoreClient;
import org.alfresco.transform.base.transform.TransformHandler;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.webmvc.test.autoconfigure.AutoConfigureMockMvc;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@SpringBootTest(classes={Application.class})
@ExtendWith(value={MockitoExtension.class})
@AutoConfigureMockMvc
public abstract class AbstractBaseTest {
    @TempDir
    public File tempDir;
    @Autowired
    protected TransformHandler transformHandler;
    @Autowired
    protected TransformController controller;
    @Autowired
    protected MockMvc mockMvc;
    @Autowired
    protected ObjectMapper objectMapper;
    @MockitoBean
    protected SharedFileStoreClient sharedFileStoreClient;
    @Autowired
    protected TransformServiceRegistry transformRegistry;
    protected String sourceExtension;
    protected String targetExtension;
    protected String sourceMimetype;
    protected String targetMimetype;
    protected HashMap<String, String> options = new HashMap();
    protected MockMultipartFile sourceFile;
    protected String expectedOptions;
    protected String expectedSourceSuffix;
    protected Long expectedTimeout = 0L;
    protected byte[] sourceFileBytes;
    protected byte[] expectedTargetFileBytes;
    private CommandExecutor commandExecutor;
    private RuntimeExec origTransformCommand;
    private RuntimeExec origCheckCommand;

    protected void setMockExternalCommandsOnTransformer(CommandExecutor commandExecutor, RuntimeExec mockTransformCommand, RuntimeExec mockCheckCommand) {
        this.commandExecutor = commandExecutor;
        this.origTransformCommand = (RuntimeExec)ReflectionTestUtils.getField((Object)commandExecutor, (String)"transformCommand");
        this.origCheckCommand = (RuntimeExec)ReflectionTestUtils.getField((Object)commandExecutor, (String)"transformCommand");
        ReflectionTestUtils.setField((Object)commandExecutor, (String)"transformCommand", (Object)mockTransformCommand);
        ReflectionTestUtils.setField((Object)commandExecutor, (String)"checkCommand", (Object)mockCheckCommand);
    }

    protected void resetExternalCommandsOnTransformer() {
        ReflectionTestUtils.setField((Object)this.commandExecutor, (String)"transformCommand", (Object)this.origTransformCommand);
        ReflectionTestUtils.setField((Object)this.commandExecutor, (String)"checkCommand", (Object)this.origCheckCommand);
    }

    protected void mockTransformCommand(String sourceExtension, String targetExtension, String sourceMimetype, boolean readTargetFileBytes) throws IOException {
    }

    protected void updateTransformRequestWithSpecificOptions(TransformRequest transformRequest) {
    }

    public void generateTargetFileFromResourceFile(String actualTargetExtension, File testFile, File targetFile) throws IOException {
        if (testFile == null) {
            testFile = this.getTestFile("quick." + actualTargetExtension, false);
        }
        if (testFile != null) {
            try (FileInputStream inputStream = new FileInputStream(testFile);
                 FileOutputStream outputStream = new FileOutputStream(targetFile);){
                FileChannel source = inputStream.getChannel();
                FileChannel target = outputStream.getChannel();
                target.transferFrom(source, 0L, source.size());
            }
        }
    }

    protected byte[] readTestFile(String extension) throws IOException {
        return Files.readAllBytes(this.getTestFile("quick." + extension, true).toPath());
    }

    protected File getTestFile(String testFilename, boolean required) throws IOException {
        return AbstractBaseTest.getTestFile(testFilename, required, this.tempDir);
    }

    public static File getTestFile(String testFilename, boolean required, File tempDir) throws IOException {
        File testFile = null;
        ClassLoader classLoader = AbstractBaseTest.class.getClassLoader();
        URL testFileUrl = classLoader.getResource(testFilename);
        if (required && testFileUrl == null) {
            throw new IOException("The test file " + testFilename + " does not exist in the resources directory");
        }
        if (testFileUrl != null) {
            testFile = new File(tempDir, testFilename);
            Files.copy(classLoader.getResourceAsStream(testFilename), testFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return testFileUrl == null ? null : testFile;
    }

    protected MockMultipartHttpServletRequestBuilder mockMvcRequest(String url, MockMultipartFile sourceFile, String ... params) {
        if (sourceFile == null) {
            return this.mockMvcRequestWithoutMockMultipartFile(url, params);
        }
        return this.mockMvcRequestWithMockMultipartFile(url, sourceFile, params);
    }

    private MockMultipartHttpServletRequestBuilder mockMvcRequestWithoutMockMultipartFile(String url, String ... params) {
        MockMultipartHttpServletRequestBuilder builder = MockMvcRequestBuilders.multipart((String)url, (Object[])new Object[0]);
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("each param should have a name and value.");
        }
        for (int i = 0; i < params.length; i += 2) {
            builder = (MockMultipartHttpServletRequestBuilder)builder.param(params[i], new String[]{params[i + 1]});
        }
        return builder;
    }

    private MockMultipartHttpServletRequestBuilder mockMvcRequestWithMockMultipartFile(String url, MockMultipartFile sourceFile, String ... params) {
        MockMultipartHttpServletRequestBuilder builder = (MockMultipartHttpServletRequestBuilder)MockMvcRequestBuilders.multipart((String)url, (Object[])new Object[0]).file(sourceFile);
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("each param should have a name and value.");
        }
        for (int i = 0; i < params.length; i += 2) {
            builder = (MockMultipartHttpServletRequestBuilder)builder.param(params[i], new String[]{params[i + 1]});
        }
        return builder;
    }

    protected TransformRequest createTransformRequest(String sourceFileRef, File sourceFile) {
        return TransformRequest.builder().withRequestId("1").withSchema(1).withClientData("Alfresco Digital Business Platform").withTransformRequestOptions(this.options).withSourceReference(sourceFileRef).withSourceExtension(this.sourceExtension).withSourceMediaType(this.sourceMimetype).withSourceSize(Long.valueOf(sourceFile.length())).withTargetExtension(this.targetExtension).withTargetMediaType(this.targetMimetype).withInternalContextForTransformEngineTests().build();
    }

    public static void resetProbeForTesting(ProbeTransform probe) {
        ReflectionTestUtils.setField((Object)probe, (String)"probeCount", (Object)0);
        ReflectionTestUtils.setField((Object)probe, (String)"transCount", (Object)0);
        ReflectionTestUtils.setField((Object)probe, (String)"normalTime", (Object)0);
        ReflectionTestUtils.setField((Object)probe, (String)"maxTime", (Object)Long.MAX_VALUE);
        ReflectionTestUtils.setField((Object)probe, (String)"nextTransformTime", (Object)0);
        ((AtomicBoolean)ReflectionTestUtils.getField((Object)probe, (String)"initialised")).set(false);
        ((AtomicBoolean)ReflectionTestUtils.getField((Object)probe, (String)"readySent")).set(false);
        ((AtomicLong)ReflectionTestUtils.getField((Object)probe, (String)"transformCount")).set(0L);
        ((AtomicBoolean)ReflectionTestUtils.getField((Object)probe, (String)"die")).set(false);
    }

    @Test
    public void simpleTransformTest() throws Exception {
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, new String[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
    }

    @Test
    public void dotDotSourceFilenameTest() throws Exception {
        this.sourceFile = new MockMultipartFile("file", "../quick." + this.sourceExtension, this.sourceMimetype, this.sourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, new String[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
    }

    @Test
    public void noExtensionSourceFilenameTest() throws Exception {
        this.options.clear();
        this.sourceFile = new MockMultipartFile("file", "../quick", this.sourceMimetype, this.sourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, new String[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
    }

    @Test
    public void calculateMaxTime() throws Exception {
        long[][] values;
        ProbeTransform probeTransform = this.controller.getProbeTransform();
        AbstractBaseTest.resetProbeForTesting(probeTransform);
        probeTransform.setLivenessPercent(110);
        for (long[] v : values = new long[][]{{5000L, 0L, Long.MAX_VALUE}, {1000L, 1000L, 2100L}, {3000L, 2000L, 4200L}, {2000L, 2000L, 4200L}, {6000L, 3000L, 6300L}, {8000L, 4000L, 8400L}, {4444L, 4000L, 8400L}, {5555L, 4000L, 8400L}}) {
            long time = v[0];
            long expectedNormalTime = v[1];
            long expectedMaxTime = v[2];
            probeTransform.calculateMaxTime(time, true);
            Assertions.assertEquals((long)expectedNormalTime, (long)probeTransform.getNormalTime());
            Assertions.assertEquals((long)expectedMaxTime, (long)probeTransform.getMaxTime());
        }
    }

    @Test
    public void testEmptyPojoTransform() throws Exception {
        TransformRequest transformRequest = new TransformRequest();
        String tr = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformationReplyAsString = this.mockMvc.perform((RequestBuilder)((MockHttpServletRequestBuilder)((MockHttpServletRequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"})).header("Content-Type", new Object[]{"application/json"})).content(tr)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformationReplyAsString, TransformReply.class);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)transformReply.getStatus());
    }

    @Test
    public void queueTransformRequestUsingDirectAccessUrlTest() throws Exception {
        String sourceFileRef = UUID.randomUUID().toString();
        File sourceFile = this.getTestFile("quick." + this.sourceExtension, true);
        String targetFileRef = UUID.randomUUID().toString();
        TransformRequest transformRequest = this.createTransformRequest(sourceFileRef, sourceFile);
        Map transformRequestOptions = transformRequest.getTransformRequestOptions();
        String directUrl = "file://" + String.valueOf(sourceFile.toPath());
        transformRequestOptions.put("directAccessUrl", directUrl);
        Mockito.when((Object)this.sharedFileStoreClient.saveFile((File)ArgumentMatchers.any())).thenReturn((Object)new FileRefResponse(new FileRefEntity(targetFileRef)));
        this.updateTransformRequestWithSpecificOptions(transformRequest);
        String tr = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformationReplyAsString = this.mockMvc.perform((RequestBuilder)((MockHttpServletRequestBuilder)((MockHttpServletRequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"})).header("Content-Type", new Object[]{"application/json"})).content(tr)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.CREATED.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformationReplyAsString, TransformReply.class);
        Assertions.assertEquals((Object)transformRequest.getRequestId(), (Object)transformReply.getRequestId());
        Assertions.assertEquals((Object)transformRequest.getClientData(), (Object)transformReply.getClientData());
        Assertions.assertEquals((int)transformRequest.getSchema(), (int)transformReply.getSchema());
    }

    @Test
    public void httpTransformRequestUsingDirectAccessUrlTest() throws Exception {
        File dauSourceFile = this.getTestFile("quick." + this.sourceExtension, true);
        String directUrl = "file://" + String.valueOf(dauSourceFile.toPath());
        ResultActions resultActions = this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", null, new String[0]).param("directAccessUrl", new String[]{directUrl})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*=UTF-8''transform." + this.targetExtension));
        if (this.expectedTargetFileBytes != null) {
            resultActions.andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes));
        }
    }
}

