/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.http;

import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithTwoCustomTransformers;
import org.alfresco.transform.base.fakes.FakeTransformerPdf2Png;
import org.alfresco.transform.base.fakes.FakeTransformerTxT2Pdf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.resttestclient.TestRestTemplate;
import org.springframework.boot.resttestclient.autoconfigure.AutoConfigureTestRestTemplate;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.util.HtmlUtils;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={Application.class})
@ContextConfiguration(classes={FakeTransformEngineWithTwoCustomTransformers.class, FakeTransformerTxT2Pdf.class, FakeTransformerPdf2Png.class})
@AutoConfigureTestRestTemplate
public class RestTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private static final HttpHeaders HEADERS = new HttpHeaders();

    @Test
    public void noFileError() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"sourceMimetype", (Object)"text/plain");
        parameters.add((Object)"targetMimetype", (Object)"application/pdf");
        ResponseEntity response = this.restTemplate.exchange("/transform", HttpMethod.POST, new HttpEntity((Object)parameters, HEADERS), String.class, new Object[]{""});
        Assertions.assertTrue((boolean)HtmlUtils.htmlUnescape((String)((String)response.getBody())).contains("Required request part 'file' is not present"));
    }

    @Test
    public void httpTransformRequestDirectAccessUrlNotFoundTest() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"directAccessUrl", (Object)"https://expired/direct/access/url");
        parameters.add((Object)"sourceMimetype", (Object)"text/plain");
        parameters.add((Object)"targetMimetype", (Object)"application/pdf");
        parameters.add((Object)"file", (Object)new ClassPathResource("original.txt"));
        ResponseEntity response = this.restTemplate.exchange("/transform", HttpMethod.POST, new HttpEntity((Object)parameters, HEADERS), String.class, new Object[]{""});
        Assertions.assertTrue((boolean)((String)response.getBody()).contains("Direct Access Url not found."));
    }

    @Test
    public void transform() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"sourceMimetype", (Object)"text/plain");
        parameters.add((Object)"targetMimetype", (Object)"application/pdf");
        parameters.add((Object)"file", (Object)new ClassPathResource("original.txt"));
        ResponseEntity response = this.restTemplate.exchange("/transform", HttpMethod.POST, new HttpEntity((Object)parameters, HEADERS), String.class, new Object[]{""});
        Assertions.assertEquals((Object)"Original Text -> TxT2Pdf()", (Object)response.getBody());
    }

    static {
        HEADERS.setContentType(MediaType.MULTIPART_FORM_DATA);
    }
}

