/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base;

import jakarta.annotation.PostConstruct;
import jakarta.jms.Destination;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.transform.base.TransformEngine;
import org.alfresco.transform.base.html.OptionsHelper;
import org.alfresco.transform.base.logging.LogEntry;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.registry.TransformRegistry;
import org.alfresco.transform.base.transform.TransformHandler;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.config.CoreVersionDecorator;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.exceptions.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TransformController {
    private static final Logger logger = LoggerFactory.getLogger(TransformController.class);
    private static final String MODEL_TITLE = "title";
    private static final String MODEL_PROXY_PATH_PREFIX = "proxyPathPrefix";
    private static final String MODEL_MESSAGE = "message";
    private static final String X_ALFRESCO_RETRY_NEEDED_HEADER = "X-Alfresco-Retry-Needed";
    @Autowired(required=false)
    private List<TransformEngine> transformEngines;
    @Autowired
    private TransformRegistry transformRegistry;
    @Autowired
    TransformHandler transformHandler;
    @Autowired
    private String coreVersion;
    @Value(value="${container.behind-ingres}")
    private boolean behindIngres;
    @Value(value="${transform.endpoint.test.enable}")
    private boolean enableTestEndpoint;
    TransformEngine transformEngine;
    private final AtomicReference<ProbeTransform> probeTransform = new AtomicReference();

    @PostConstruct
    private void initTransformEngine() {
        if (this.transformEngines != null) {
            this.transformEngine = this.getTransformEngine();
            logger.info("TransformEngine: {}", (Object)this.transformEngine.getTransformEngineName());
            this.transformEngines.stream().filter(transformEngineFromStream -> transformEngineFromStream != this.transformEngine).sorted(Comparator.comparing(TransformEngine::getTransformEngineName)).map(sortedTransformEngine -> "  " + sortedTransformEngine.getTransformEngineName()).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        }
    }

    private TransformEngine getTransformEngine() {
        return this.transformEngines.stream().filter(transformEngineFromStream -> transformEngineFromStream.getTransformConfig() == null).findFirst().orElse(this.transformEngines.get(0));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void startup() {
        logger.info("--------------------------------------------------------------------------------------------------------------------------------------------------------------");
        if (this.transformEngines != null) {
            this.logSplitMessage(this.transformEngine.getStartupMessage());
        }
        logger.info("--------------------------------------------------------------------------------------------------------------------------------------------------------------");
        logger.info("Starting application components... Done");
    }

    private void logSplitMessage(String message) {
        Arrays.stream(message.split("\\n")).forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    @RequestMapping(value={"/version"})
    @ResponseBody
    public String version() {
        return this.getSimpleTransformEngineName() + " " + this.coreVersion;
    }

    @GetMapping(value={"/"})
    public String test(Model model) {
        model.addAttribute(MODEL_TITLE, (Object)(this.getSimpleTransformEngineName() + " Test Page"));
        model.addAttribute(MODEL_PROXY_PATH_PREFIX, this.getPathPrefix());
        TransformConfig transformConfig = this.transformRegistry.getTransformConfig();
        transformConfig = CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfig, (int)0);
        model.addAttribute("transformOptions", OptionsHelper.getOptionNames(transformConfig.getTransformOptions()));
        return "test";
    }

    @GetMapping(value={"/error"})
    public String error(Model model) {
        model.addAttribute(MODEL_TITLE, (Object)(this.getSimpleTransformEngineName() + " Error Page"));
        model.addAttribute(MODEL_PROXY_PATH_PREFIX, this.getPathPrefix());
        return "error";
    }

    @GetMapping(value={"/log"})
    String log(Model model) {
        model.addAttribute(MODEL_TITLE, (Object)(this.getSimpleTransformEngineName() + " Log Entries"));
        model.addAttribute(MODEL_PROXY_PATH_PREFIX, this.getPathPrefix());
        Collection<LogEntry> log = LogEntry.getLog();
        if (!log.isEmpty()) {
            model.addAttribute("log", log);
        }
        return "log";
    }

    private Object getPathPrefix() {
        Object pathPrefix = "";
        if (this.behindIngres) {
            pathPrefix = "/" + this.getSimpleTransformEngineName().toLowerCase();
        }
        return pathPrefix;
    }

    private String getSimpleTransformEngineName() {
        return this.transformEngine.getTransformEngineName().replaceFirst("^\\d+ ", "");
    }

    @GetMapping(value={"/ready"})
    @ResponseBody
    public String ready(HttpServletRequest request) {
        return this.getProbeTransform().doTransformOrNothing(false, this.transformHandler);
    }

    @GetMapping(value={"/live"})
    @ResponseBody
    public String live(HttpServletRequest request) {
        return this.getProbeTransform().doTransformOrNothing(true, this.transformHandler);
    }

    public ProbeTransform getProbeTransform() {
        ProbeTransform probe = this.probeTransform.get();
        if (probe != null) {
            return probe;
        }
        probe = this.transformEngine.getProbeTransform();
        if (this.probeTransform.compareAndSet(null, probe)) {
            return probe;
        }
        return this.probeTransform.get();
    }

    @GetMapping(value={"/transform/config"})
    public ResponseEntity<TransformConfig> transformConfig(@RequestParam(value="configVersion", defaultValue="1") int configVersion) {
        logger.info("GET Transform Config version: " + configVersion);
        TransformConfig transformConfig = this.transformRegistry.getTransformConfig();
        transformConfig = CoreVersionDecorator.setOrClearCoreVersion((TransformConfig)transformConfig, (int)configVersion);
        if (this.transformRegistry.isRecoveryModeOn()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(X_ALFRESCO_RETRY_NEEDED_HEADER, new String[]{"RecoveryModeOn"})).body((Object)transformConfig);
        }
        return ResponseEntity.ok().body((Object)transformConfig);
    }

    @PostMapping(value={"/transform"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<TransformReply> transform(@RequestBody TransformRequest request, @RequestParam(value="timeout", required=false) Long timeout, @RequestParam(value="replyToQueue", required=false) Destination replyToQueue) {
        TransformReply reply = this.transformHandler.handleMessageRequest(request, timeout, replyToQueue, this.getProbeTransform());
        return new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()));
    }

    @PostMapping(value={"/transform"}, consumes={"multipart/form-data"})
    public ResponseEntity<Resource> transform(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile sourceMultipartFile, @RequestParam(value="sourceMimetype") String sourceMimetype, @RequestParam(value="targetMimetype") String targetMimetype, @RequestParam Map<String, String> requestParameters) {
        return this.transformHandler.handleHttpRequest(request, sourceMultipartFile, sourceMimetype, targetMimetype, requestParameters, this.getProbeTransform());
    }

    @PostMapping(value={"/test"}, consumes={"multipart/form-data"})
    public ResponseEntity<Resource> testTransform(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile sourceMultipartFile, @RequestParam(value="sourceMimetype", required=false) String sourceMimetype, @RequestParam(value="targetMimetype", required=false) String targetMimetype, @RequestParam Map<String, String> origRequestParameters) {
        if (!this.enableTestEndpoint) {
            throw new TransformException(HttpStatus.FORBIDDEN, "Test endpoint is disabled");
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        sourceMimetype = this.overrideMimetypeFromExtension(origRequestParameters, "sourceMimetype", sourceMimetype);
        targetMimetype = this.overrideMimetypeFromExtension(origRequestParameters, "targetMimetype", targetMimetype);
        origRequestParameters.forEach((name, value) -> {
            if (!name.startsWith("value")) {
                if (name.startsWith("name")) {
                    String suffix = name.substring("name".length());
                    name = value;
                    value = (String)origRequestParameters.get("value" + suffix);
                }
                if (name != null && !name.isBlank() && value != null && !value.isBlank()) {
                    requestParameters.put((String)name, (String)value);
                }
            }
        });
        return this.transform(request, sourceMultipartFile, sourceMimetype, targetMimetype, requestParameters);
    }

    private String overrideMimetypeFromExtension(Map<String, String> origRequestParameters, String name, String value) {
        String override = origRequestParameters.remove("_" + name);
        if (override != null && !override.isBlank()) {
            value = override;
            origRequestParameters.put(name, value);
        }
        return value;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public void handleMissingParams(HttpServletResponse response, MissingServletRequestParameterException e) throws IOException {
        String message = MessageFormat.format("Request parameter ''{0}'' is missing", e.getParameterName());
        logger.error(message, (Throwable)e);
        response.sendError(HttpStatus.BAD_REQUEST.value(), message);
    }

    @ExceptionHandler(value={TransformException.class})
    public ModelAndView handleTransformException(HttpServletResponse response, TransformException e) throws IOException {
        String message = e.getMessage();
        logger.error(message);
        response.sendError(e.getStatus().value(), message);
        ModelAndView mav = new ModelAndView();
        mav.addObject(MODEL_TITLE, (Object)(this.getSimpleTransformEngineName() + " Error Page"));
        mav.addObject(MODEL_PROXY_PATH_PREFIX, this.getPathPrefix());
        mav.addObject(MODEL_MESSAGE, (Object)message);
        mav.setViewName("error");
        return mav;
    }
}

