/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.transform.base.registry.TransformConfigFromFiles;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ConfigurationProperties(prefix="transformer.routes")
public class TransformConfigFilesHistoric {
    private final Map<String, String> additional = new HashMap<String, String>();
    private String TRANSFORMER_ROUTES_FROM_CLASSPATH = "transformer-pipelines.json";
    @Value(value="${transformer-routes-path}")
    private String transformerRoutesExternalFile;

    public Map<String, String> getAdditional() {
        return this.additional;
    }

    public List<Resource> retrieveResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        this.addStandardConfigIfItExists(resources);
        resources.addAll(TransformConfigFromFiles.retrieveResources(this.additional));
        return resources;
    }

    private void addStandardConfigIfItExists(ArrayList<Resource> resources) {
        Resource resource = null;
        if (this.transformerRoutesExternalFile != null && !this.transformerRoutesExternalFile.isBlank()) {
            resource = TransformConfigFromFiles.retrieveResource(this.transformerRoutesExternalFile);
        }
        if (resource == null || !resource.exists()) {
            resource = new ClassPathResource(this.TRANSFORMER_ROUTES_FROM_CLASSPATH);
        }
        if (resource.exists()) {
            resources.add(resource);
        }
    }
}

