/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.sfs;

import jakarta.annotation.PostConstruct;
import java.io.File;
import javax.net.ssl.SSLException;
import org.alfresco.transform.base.WebClientBuilderAdjuster;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.exceptions.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class SharedFileStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(SharedFileStoreClient.class);
    @Value(value="${filestore-url}")
    private String url;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WebClientBuilderAdjuster adjuster;
    private WebClient client;

    @PostConstruct
    public void init() throws SSLException {
        WebClient.Builder clientBuilder = WebClient.builder();
        this.adjuster.adjust(clientBuilder);
        this.client = clientBuilder.baseUrl((String)(this.url.endsWith("/") ? this.url : this.url + "/")).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).build();
    }

    public ResponseEntity<Resource> retrieveFile(String fileRef) {
        try {
            return this.restTemplate.getForEntity(this.url + "/" + fileRef, Resource.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new TransformException(HttpStatus.resolve((int)e.getStatusCode().value()), e.getMessage(), (Throwable)e);
        }
    }

    public FileRefResponse saveFile(File file) {
        try {
            FileSystemResource value = new FileSystemResource(file.getAbsolutePath());
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"file", (Object)value);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity requestEntity = new HttpEntity((Object)map, headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, FileRefResponse.class, new Object[0]);
            return (FileRefResponse)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            throw new TransformException(HttpStatus.resolve((int)e.getStatusCode().value()), e.getMessage(), (Throwable)e);
        }
    }

    @Async
    public void asyncDelete(String fileReference) {
        try {
            logger.debug("                  Deleting intermediate file {}", (Object)fileReference);
            this.client.delete().uri(fileReference, new Object[0]).retrieve().toBodilessEntity().block();
        }
        catch (Exception e) {
            logger.error("Failed to delete intermediate file {}: {}", (Object)fileReference, (Object)e.getMessage());
        }
    }
}

