/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base;

import java.net.URISyntaxException;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.WebClient;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class LivenessReadinessProbeTest {
    protected final Integer MAX_TRANSFORMS = 10;

    @Test
    public void readinessShouldReturnAn429ErrorAfterReachingMaxTransforms() throws URISyntaxException {
        ImagesForTests testData = this.getImageForTest();
        try (GenericContainer<?> env = this.createEnv(testData.image);){
            env.start();
            String url = "http://localhost:" + env.getFirstMappedPort();
            for (int i = 0; i < this.MAX_TRANSFORMS / 2; ++i) {
                LivenessReadinessProbeTest.assertProbeIsOk(url);
                this.sendTransformRequest(url, testData.sourceMimetype, testData.targetMimetype, testData.filename);
            }
            LivenessReadinessProbeTest.assertProbeDied(url);
            String logs = env.getLogs();
            System.out.println(logs);
        }
    }

    protected abstract ImagesForTests getImageForTest();

    private GenericContainer<?> createEnv(String image) throws URISyntaxException {
        System.out.println(image);
        GenericContainer transformCore = new GenericContainer("alfresco/" + image + ":latest");
        return transformCore.withEnv("livenessTransformEnabled", "true").withEnv("maxTransforms", this.MAX_TRANSFORMS.toString()).withEnv("TRANSFORM_ENDPOINT_TEST_ENABLE", "true").withNetworkAliases(new String[]{image}).withExposedPorts(new Integer[]{8090}).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    private void sendTransformRequest(String url, String sourceMimetype, String targetMimetype, String filename) {
        MultipartBodyBuilder builder = this.createRequestBuilder(sourceMimetype, targetMimetype, filename);
        WebClient client = WebClient.create();
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)client.post().uri(url + "/test", new Object[0])).bodyValue((Object)builder.build()).retrieve();
        System.out.println(responseSpec.toBodilessEntity().block());
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)((ResponseEntity)responseSpec.toBodilessEntity().block()).getStatusCode());
    }

    private MultipartBodyBuilder createRequestBuilder(String sourceMimetype, String targetMimetype, String filename) {
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("_sourceMimetype", (Object)sourceMimetype);
        builder.part("_targetMimetype", (Object)targetMimetype);
        builder.part("file", (Object)new ClassPathResource(filename));
        return builder;
    }

    private static void assertProbeDied(String url) {
        WebTestClient client = WebTestClient.bindToServer().baseUrl(url + "/ready").build();
        client.get().exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
    }

    private static void assertProbeIsOk(String url) {
        WebTestClient client = WebTestClient.bindToServer().baseUrl(url + "/ready").build();
        client.get().exchange().expectStatus().isEqualTo((HttpStatusCode)HttpStatus.OK);
    }

    protected static class ImagesForTests {
        private final String image;
        private final String sourceMimetype;
        private final String targetMimetype;
        private final String filename;

        public ImagesForTests(String image, String sourceMimetype, String targetMimetype, String filename) {
            this.image = Objects.requireNonNull(image);
            this.sourceMimetype = Objects.requireNonNull(sourceMimetype);
            this.targetMimetype = Objects.requireNonNull(targetMimetype);
            this.filename = Objects.requireNonNull(filename);
        }
    }
}

