/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.util.AbstractExceptionBuilder;
import java.lang.reflect.Constructor;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SequentialIOExceptionBuilder<C extends Exception, X extends SequentialIOException>
extends AbstractExceptionBuilder<C, X> {
    private final Class<X> assemblyClass;
    private volatile Constructor<X> assemblyConstructor;

    public static SequentialIOExceptionBuilder<Exception, SequentialIOException> create() {
        return SequentialIOExceptionBuilder.create(Exception.class, SequentialIOException.class);
    }

    public static <C extends Exception> SequentialIOExceptionBuilder<C, SequentialIOException> create(Class<C> clazz) {
        return SequentialIOExceptionBuilder.create(clazz, SequentialIOException.class);
    }

    public static <C extends Exception, X extends SequentialIOException> SequentialIOExceptionBuilder<C, X> create(Class<C> cause, Class<X> assembly) {
        return new SequentialIOExceptionBuilder<C, X>(cause, assembly);
    }

    public SequentialIOExceptionBuilder(Class<C> causeClass, Class<X> assemblyClass) {
        this.assemblyClass = assemblyClass;
        try {
            if (!assemblyClass.isAssignableFrom(causeClass)) {
                this.wrap(null);
            }
        }
        catch (IllegalStateException ex) {
            throw new IllegalArgumentException(ex.getCause());
        }
    }

    private Class<X> assemblyClass() {
        return this.assemblyClass;
    }

    private Constructor<X> assemblyConstructor() {
        Constructor<X> ctor = this.assemblyConstructor;
        return null != ctor ? ctor : (this.assemblyConstructor = this.newAssemblyConstructor());
    }

    private Constructor<X> newAssemblyConstructor() {
        try {
            return this.assemblyClass().getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected final X update(C cause, X previous) {
        SequentialIOException assembly = null;
        if (this.assemblyClass().isInstance(cause) && (assembly = (SequentialIOException)cause).isInitPredecessor()) {
            if (null == previous) {
                return (X)assembly;
            }
            assembly = null;
        }
        if (null == assembly) {
            assembly = this.wrap(cause);
        }
        assembly.initPredecessor((SequentialIOException)previous);
        return (X)assembly;
    }

    private X wrap(@CheckForNull C cause) {
        X assembly = this.newAssembly(SequentialIOExceptionBuilder.toString(cause));
        ((SequentialIOException)assembly).initCause((Throwable)cause);
        return assembly;
    }

    private static String toString(@CheckForNull Object obj) {
        return null == obj ? "" : obj.toString();
    }

    private X newAssembly(String message) {
        Constructor<X> ctor = this.assemblyConstructor();
        try {
            try {
                return (X)((SequentialIOException)ctor.newInstance(message));
            }
            catch (IllegalAccessException ex) {
                ctor.setAccessible(true);
                return (X)((SequentialIOException)ctor.newInstance(message));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected final X post(X assembly) {
        return (X)((SequentialIOException)assembly).sortPriority();
    }
}

