/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDClock;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LazyRandom;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeBasedEpochGenerator
extends NoArgGenerator {
    private static final int ENTROPY_BYTE_LENGTH = 10;
    protected final Random _random;
    protected final UUIDClock _clock;
    private long _lastTimestamp = -1L;
    private final byte[] _lastEntropy = new byte[10];
    private final Lock lock = new ReentrantLock();

    public TimeBasedEpochGenerator(Random rnd) {
        this(rnd, UUIDClock.systemTimeClock());
    }

    public TimeBasedEpochGenerator(Random rnd, UUIDClock clock) {
        if (rnd == null) {
            rnd = LazyRandom.sharedSecureRandom();
        }
        this._random = rnd;
        this._clock = clock;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_EPOCH;
    }

    @Override
    public UUID generate() {
        return this.construct(this._clock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID construct(long rawTimestamp) {
        this.lock.lock();
        try {
            if (rawTimestamp == this._lastTimestamp) {
                boolean c = true;
                for (int i = 9; i >= 0; --i) {
                    if (!c) continue;
                    byte temp = this._lastEntropy[i];
                    temp = (byte)(temp + 1);
                    c = this._lastEntropy[i] == -1;
                    this._lastEntropy[i] = temp;
                }
                if (c) {
                    throw new IllegalStateException("overflow on same millisecond");
                }
            } else {
                this._lastTimestamp = rawTimestamp;
                this._random.nextBytes(this._lastEntropy);
            }
            UUID uUID = UUIDUtil.constructUUID(UUIDType.TIME_BASED_EPOCH, rawTimestamp << 16 | TimeBasedEpochGenerator._toShort(this._lastEntropy, 0), TimeBasedEpochGenerator._toLong(this._lastEntropy, 2));
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }
}

