/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryptor;

import org.alfresco.encryptor.PublicPrivateKeyShareStringEncryptor;

public class ShareStringEncryption {
    static final String CMD_INITKEY = "initkey";
    static final String CMD_ENCRYPT = "encrypt";
    static final String CMD_VALIDATE = "validate";
    static final String USAGE = "USAGE : " + ShareStringEncryption.class.getName() + " initkey | encrypt | validate <shared dir> ";
    static final String USAGE_1 = " initkey : initialise the public and private keystores";
    static final String USAGE_2 = " encrypt : encrypt a value ";
    static final String USAGE_3 = " validate : compare an encrypted value with a value to see if they match";
    private static final int USAGE_EXIT_CODE = 255;
    private static final int ERROR_EXIT_CODE = 1;
    private static final int SUCCESS_EXIT_CODE = 0;
    static final String USAGE_INITKEY = "USAGE : " + ShareStringEncryption.class.getName() + " initkey <shared dir> ";
    static final String USAGE_ENCRYPT = "USAGE : " + ShareStringEncryption.class.getName() + " encrypt <shared dir> [value to encrypt]";
    static final String USAGE_DECRYPT = "USAGE : " + ShareStringEncryption.class.getName() + " validate <shared dir> encrypted_value [value]";

    public static void main(String[] args) {
        block20: {
            if (args.length < 1) {
                System.out.println("Alfresco Share  Encrypted String Tool");
                System.err.println(USAGE);
                System.err.println("");
                System.err.println(USAGE_1);
                System.err.println(USAGE_2);
                System.err.println(USAGE_3);
                System.exit(255);
            }
            PublicPrivateKeyShareStringEncryptor enc = new PublicPrivateKeyShareStringEncryptor();
            String shareExtensionsDirectory = null;
            if (args.length > 1) {
                shareExtensionsDirectory = args[1];
                if (!args[0].equalsIgnoreCase(CMD_INITKEY)) {
                    enc.initPublic(shareExtensionsDirectory);
                    enc.initPrivate(shareExtensionsDirectory);
                    if (enc.publicKey == null || enc.privateKey == null) {
                        System.err.println("Please run initkey before encrypting or validating passwords");
                        System.exit(255);
                    }
                }
            }
            if (args[0].equalsIgnoreCase(CMD_INITKEY)) {
                if (args.length < 2) {
                    System.err.println(USAGE_INITKEY);
                    System.exit(255);
                }
                try {
                    enc.createKeyFiles(shareExtensionsDirectory);
                    System.out.println("The key files have been generated, please set permissions on the private key to keep it protected.");
                    System.exit(0);
                }
                catch (Throwable t) {
                    System.err.println("unable to initialise keys");
                    t.printStackTrace(System.err);
                    System.exit(1);
                }
            } else if (args[0].equalsIgnoreCase(CMD_ENCRYPT)) {
                if (args.length < 2) {
                    System.err.println(USAGE_ENCRYPT);
                    System.exit(255);
                }
                String password = null;
                password = args.length > 2 ? args[2] : enc.getPasswordFromConsole();
                try {
                    System.out.println(enc.encrypt(password));
                    System.exit(0);
                }
                catch (Throwable t) {
                    System.err.println("Error : Unable to encrypt : " + t.getMessage());
                    t.printStackTrace(System.err);
                    System.exit(1);
                }
            } else if (args[0].equalsIgnoreCase(CMD_VALIDATE)) {
                if (args.length < 3) {
                    System.err.println(USAGE_DECRYPT);
                    System.exit(255);
                }
                String password = null;
                password = args.length > 3 ? args[3] : enc.getPasswordFromConsole();
                String encryptedValue = args[2];
                try {
                    String decryptedValue = enc.decrypt(encryptedValue);
                    if (decryptedValue.equals(password)) {
                        System.out.println("The value and encrypted value MATCH");
                        System.exit(0);
                        break block20;
                    }
                    System.out.println("The value and encrypted value DO NOT MATCH");
                    System.exit(1);
                }
                catch (Throwable t) {
                    System.err.println("Error : Unable to validate :" + t.getMessage());
                    t.printStackTrace(System.err);
                    System.exit(1);
                }
            } else {
                System.err.println(USAGE);
                System.err.println("");
                System.err.println(USAGE_1);
                System.err.println(USAGE_2);
                System.err.println(USAGE_3);
                System.err.println("");
                System.err.println("BAD COMMAND: " + args[0]);
                System.exit(255);
            }
        }
        System.exit(1);
    }
}

