/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Stack;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AlfrescoSecureContext;
import org.alfresco.repo.security.authentication.AlfrescoSecureContextImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.repo.tenant.TenantContextHolder;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.log.NDC;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

@AlfrescoPublicApi
public class AuthenticationUtil
implements InitializingBean {
    static Log logger = LogFactory.getLog(AuthenticationUtil.class);
    private static boolean initialized = false;
    public static final String SYSTEM_USER_NAME = "System";
    private static String defaultAdminUserName = "ROLE_ADMINISTRATOR";
    private static String defaultGuestUserName = "ROLE_GUEST";
    private static boolean mtEnabled = false;
    private static ThreadLocal<Stack<Authentication>> threadLocalFullAuthenticationStack = new ThreadLocalStack();
    private static ThreadLocal<Stack<Authentication>> threadLocalRunAsAuthenticationStack = new ThreadLocalStack();
    private static ThreadLocal<Stack<String>> threadLocalTenantDomainStack = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };

    public void afterPropertiesSet() throws Exception {
        initialized = true;
    }

    public void setDefaultAdminUserName(String defaultAdminUserName) {
        AuthenticationUtil.defaultAdminUserName = defaultAdminUserName;
    }

    public void setDefaultGuestUserName(String defaultGuestUserName) {
        AuthenticationUtil.defaultGuestUserName = defaultGuestUserName;
    }

    public static void setMtEnabled(boolean mtEnabled) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MT is enabled: " + mtEnabled));
        }
        AuthenticationUtil.mtEnabled = mtEnabled;
    }

    public static boolean isMtEnabled() {
        return mtEnabled;
    }

    public static String maskUsername(String userName) {
        if (userName != null) {
            block4: {
                try {
                    if (userName.length() >= 2) {
                        return userName.substring(0, 2) + new String(new char[userName.length() - 2]).replace("\u0000", "*");
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Failed to mask the username because: " + e.getMessage()), (Throwable)e);
                }
            }
            return userName;
        }
        return null;
    }

    public static String getMaskedUsername(Authentication authentication) {
        String extractedUsername = null;
        if (authentication != null && authentication.getPrincipal() != null) {
            extractedUsername = AuthenticationUtil.getUserName(authentication);
        }
        return AuthenticationUtil.maskUsername(extractedUsername);
    }

    private static UsernamePasswordAuthenticationToken getAuthenticationToken(String userName, UserDetails providedDetails) {
        GrantedAuthority[] gas;
        UserDetails ud = null;
        if (userName.equals(SYSTEM_USER_NAME)) {
            gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
            ud = new User(SYSTEM_USER_NAME, "", true, true, true, true, gas);
        } else if (userName.equalsIgnoreCase(AuthenticationUtil.getGuestUserName())) {
            gas = new GrantedAuthority[]{};
            ud = new User(AuthenticationUtil.getGuestUserName().toLowerCase(), "", true, true, true, true, gas);
        } else if (providedDetails.getUsername().equals(userName)) {
            ud = providedDetails;
        } else {
            throw new AuthenticationException("Provided user details do not match the user name");
        }
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
        auth.setDetails((Object)ud);
        auth.setAuthenticated(true);
        return auth;
    }

    private static UserDetails getDefaultUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    private static String getUserName(Authentication authentication) {
        if (authentication.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    public static Authentication setAdminUserAsFullyAuthenticatedUser() {
        return AuthenticationUtil.setFullyAuthenticatedUser(AuthenticationUtil.getAdminUserName());
    }

    public static Authentication setFullyAuthenticatedUser(String userName) {
        return AuthenticationUtil.setFullyAuthenticatedUser(userName, AuthenticationUtil.getDefaultUserDetails(userName));
    }

    private static Authentication setFullyAuthenticatedUser(String userNameIn, UserDetails providedDetails) throws AuthenticationException {
        if (userNameIn == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            Pair<String, String> userTenant = AuthenticationUtil.getUserTenant(userNameIn);
            String userName = (String)userTenant.getFirst();
            String tenantDomain = (String)userTenant.getSecond();
            UsernamePasswordAuthenticationToken auth = AuthenticationUtil.getAuthenticationToken(userName, providedDetails);
            Authentication authentication = AuthenticationUtil.setFullAuthentication((Authentication)auth);
            TenantContextHolder.setTenantDomain(tenantDomain);
            return authentication;
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    public static Authentication setFullAuthentication(Authentication authentication) {
        if (authentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting fully authenticated principal: " + AuthenticationUtil.getMaskedUsername(authentication)));
        }
        Context context = ContextHolder.getContext();
        AlfrescoSecureContext sc = null;
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            sc = new AlfrescoSecureContextImpl();
            ContextHolder.setContext((Context)sc);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting new secure context: " + String.valueOf(sc) + " on thread: " + Thread.currentThread().getName()));
            }
        } else {
            sc = (AlfrescoSecureContext)context;
        }
        authentication.setAuthenticated(true);
        sc.setRealAuthentication(authentication);
        sc.setEffectiveAuthentication(authentication);
        return authentication;
    }

    public static Authentication setRunAsUserSystem() {
        return AuthenticationUtil.setRunAsUser(SYSTEM_USER_NAME);
    }

    public static Authentication setRunAsUser(String userName) {
        return AuthenticationUtil.setRunAsUser(userName, AuthenticationUtil.getDefaultUserDetails(userName));
    }

    static Authentication setRunAsUser(String userName, UserDetails providedDetails) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            UsernamePasswordAuthenticationToken auth = AuthenticationUtil.getAuthenticationToken(userName, providedDetails);
            return AuthenticationUtil.setRunAsAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    static Authentication setRunAsAuthentication(Authentication authentication) {
        if (authentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting RunAs principal: " + AuthenticationUtil.getMaskedUsername(authentication)));
        }
        Context context = ContextHolder.getContext();
        AlfrescoSecureContext sc = null;
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            sc = new AlfrescoSecureContextImpl();
            ContextHolder.setContext((Context)sc);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting new secure context: " + String.valueOf(sc) + " on thread: " + Thread.currentThread().getName()));
            }
        } else {
            sc = (AlfrescoSecureContext)context;
        }
        authentication.setAuthenticated(true);
        if (sc.getRealAuthentication() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("There is no fully authenticated principal. Setting fully authenticated principal: " + AuthenticationUtil.getMaskedUsername(authentication)));
            }
            sc.setRealAuthentication(authentication);
        }
        sc.setEffectiveAuthentication(authentication);
        return authentication;
    }

    public static Authentication getRunAsAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        return ((AlfrescoSecureContext)context).getEffectiveAuthentication();
    }

    public static Authentication getFullAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        return ((AlfrescoSecureContext)context).getRealAuthentication();
    }

    public static String getRunAsUser() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        AlfrescoSecureContext ctx = (AlfrescoSecureContext)context;
        if (ctx.getEffectiveAuthentication() == null) {
            return null;
        }
        return AuthenticationUtil.getUserName(ctx.getEffectiveAuthentication());
    }

    public static boolean isRunAsUserTheSystemUser() {
        int idx;
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser != null && AuthenticationUtil.isMtEnabled() && (idx = runAsUser.indexOf("@")) != -1) {
            runAsUser = runAsUser.substring(0, idx);
        }
        return EqualsHelper.nullSafeEquals((Object)runAsUser, (Object)SYSTEM_USER_NAME);
    }

    public static String getFullyAuthenticatedUser() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            return null;
        }
        AlfrescoSecureContext ctx = (AlfrescoSecureContext)context;
        if (ctx.getRealAuthentication() == null) {
            return null;
        }
        return AuthenticationUtil.getUserName(ctx.getRealAuthentication());
    }

    public static String getSystemUserName() {
        return SYSTEM_USER_NAME;
    }

    public static String getAdminUserName() {
        String tenantDomain;
        String runAsUser;
        if (!initialized) {
            throw new IllegalStateException("AuthenticationUtil not yet initialised; default admin username not available");
        }
        if (AuthenticationUtil.isMtEnabled() && (runAsUser = AuthenticationUtil.getRunAsUser()) != null && !"".equals(tenantDomain = (String)AuthenticationUtil.getUserTenant(runAsUser).getSecond())) {
            return defaultAdminUserName + "@" + tenantDomain;
        }
        return defaultAdminUserName;
    }

    public static String getAdminRoleName() {
        return "ROLE_ADMINISTRATOR";
    }

    public static String getGuestUserName() {
        if (!initialized) {
            throw new IllegalStateException("AuthenticationUtil not yet initialised; default guest username not available");
        }
        return defaultGuestUserName;
    }

    public static String getGuestRoleName() {
        return "ROLE_GUEST";
    }

    public static void clearCurrentSecurityContext() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Removing the current security information for thread: " + Thread.currentThread().getName()));
        }
        ContextHolder.setContext(null);
        InMemoryTicketComponentImpl.clearCurrentSecurityContext();
        NDC.remove();
        TenantContextHolder.clearTenantDomain();
    }

    public static <R> R runAs(RunAsWork<R> runAsWork, String uid) {
        Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
        Authentication originalRunAsAuthentication = AuthenticationUtil.getRunAsAuthentication();
        try {
            R result;
            if (originalFullAuthentication == null) {
                AuthenticationUtil.setFullyAuthenticatedUser(uid);
            } else {
                AuthenticationUtil.setRunAsUser(uid);
            }
            AuthenticationUtil.logNDC(uid);
            R r = result = runAsWork.doWork();
            return r;
        }
        catch (Throwable exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during run as.", exception);
        }
        finally {
            if (originalFullAuthentication == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Removing the current security information for thread: " + Thread.currentThread().getName()));
                }
                ContextHolder.setContext(null);
                TenantContextHolder.clearTenantDomain();
                AuthenticationUtil.logNDC(null);
            } else {
                AuthenticationUtil.setFullAuthentication(originalFullAuthentication);
                AuthenticationUtil.setRunAsAuthentication(originalRunAsAuthentication);
                AuthenticationUtil.logNDC(AuthenticationUtil.getUserName(originalFullAuthentication));
            }
        }
    }

    public static <R> R runAsSystem(RunAsWork<R> runAsWork) {
        return AuthenticationUtil.runAs(runAsWork, AuthenticationUtil.getSystemUserName());
    }

    public static void pushAuthentication() {
        Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
        Authentication originalRunAsAuthentication = AuthenticationUtil.getRunAsAuthentication();
        threadLocalFullAuthenticationStack.get().push(originalFullAuthentication);
        threadLocalRunAsAuthenticationStack.get().push(originalRunAsAuthentication);
        threadLocalTenantDomainStack.get().push(TenantContextHolder.getTenantDomain());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Pushed authentication in thread: " + Thread.currentThread().getName()));
        }
    }

    public static void popAuthentication() {
        Authentication originalFullAuthentication = threadLocalFullAuthenticationStack.get().pop();
        Authentication originalRunAsAuthentication = threadLocalRunAsAuthenticationStack.get().pop();
        if (originalFullAuthentication == null) {
            AuthenticationUtil.clearCurrentSecurityContext();
        } else {
            AuthenticationUtil.setFullAuthentication(originalFullAuthentication);
            AuthenticationUtil.setRunAsAuthentication(originalRunAsAuthentication);
        }
        String originalTenantDomain = threadLocalTenantDomainStack.get().pop();
        TenantContextHolder.setTenantDomain(originalTenantDomain);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Popped authentication in thread: " + Thread.currentThread().getName()));
        }
    }

    public static void logAuthenticatedUsers() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication: \n   Fully authenticated: " + AuthenticationUtil.maskUsername(AuthenticationUtil.getFullyAuthenticatedUser()) + "\n   Run as:              " + AuthenticationUtil.maskUsername(AuthenticationUtil.getRunAsUser())));
        }
    }

    public static void logNDC(String userNameIn) {
        NDC.remove();
        if (userNameIn != null) {
            if (AuthenticationUtil.isMtEnabled()) {
                Pair<String, String> userTenant = AuthenticationUtil.getUserTenant(userNameIn);
                String userName = (String)userTenant.getFirst();
                String tenantDomain = (String)userTenant.getSecond();
                if (!"".equals(tenantDomain)) {
                    NDC.push((String)("Tenant:" + tenantDomain + " User:" + AuthenticationUtil.maskUsername(userName)));
                } else {
                    NDC.push((String)("User:" + AuthenticationUtil.maskUsername(userName)));
                }
            } else {
                NDC.push((String)("User:" + AuthenticationUtil.maskUsername(userNameIn)));
            }
        }
    }

    public static Pair<String, String> getUserTenant(String userName) {
        String tenantDomain = TenantContextHolder.getTenantDomain();
        if (tenantDomain == null) {
            int idx;
            tenantDomain = "";
            if (userName != null && AuthenticationUtil.isMtEnabled() && (idx = userName.indexOf("@")) > 0 && idx < userName.length() - 1) {
                tenantDomain = userName.substring(idx + 1);
                if (tenantDomain.indexOf("@") > 0) {
                    throw new AlfrescoRuntimeException("Unexpected tenant: " + tenantDomain + " (contains @)");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Tenant domain implied: userName=" + AuthenticationUtil.maskUsername(userName) + ", tenantDomain=" + tenantDomain));
                }
            }
        }
        return new Pair((Object)userName, (Object)tenantDomain);
    }

    @AlfrescoPublicApi
    public static interface RunAsWork<Result> {
        public Result doWork() throws Exception;
    }

    static class ThreadLocalStack
    extends ThreadLocal<Stack<Authentication>> {
        ThreadLocalStack() {
        }

        @Override
        protected Stack<Authentication> initialValue() {
            return new Stack<Authentication>();
        }
    }
}

