/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSRange;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;

public class LuceneFTSRange<Q, S, E extends Throwable>
extends FTSRange
implements LuceneQueryBuilderComponent<Q, S, E> {
    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        Q query;
        QueryParserAdaptor<Q, S, E> lqpa = luceneContext.getLuceneQueryParserAdaptor();
        Argument argument = functionArgs.get("FromInc");
        Boolean fromInc = (Boolean)argument.getValue(functionContext);
        argument = functionArgs.get("From");
        String from = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("To");
        String to = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("ToInc");
        Boolean toInc = (Boolean)argument.getValue(functionContext);
        PropertyArgument propArg = (PropertyArgument)functionArgs.get("Property");
        if (propArg != null) {
            String prop = propArg.getPropertyName();
            query = lqpa.getRangeQuery(functionContext.getLuceneFieldName(prop), from, to, fromInc, toInc, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        } else {
            query = lqpa.getRangeQuery(lqpa.getField(), from, to, fromInc, toInc, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        return query;
    }
}

