/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchDateConversion;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class SearchDateConversionTest {
    SearchDateConversion subject = new SearchDateConversion();

    @Test
    public void parseDateString() throws Exception {
        this.setDefaults();
        Pair result = SearchDateConversion.parseDateString((String)"2017");
        Assert.assertEquals((long)1L, (long)((Integer)result.getSecond()).intValue());
        Assert.assertEquals((long)1483228800000L, (long)((Date)result.getFirst()).getTime());
        result = SearchDateConversion.parseDateString((String)"2017-12");
        Assert.assertEquals((long)2L, (long)((Integer)result.getSecond()).intValue());
        Assert.assertEquals((long)1512086400000L, (long)((Date)result.getFirst()).getTime());
        result = SearchDateConversion.parseDateString((String)"2017-12-12");
        Assert.assertEquals((long)5L, (long)((Integer)result.getSecond()).intValue());
        Assert.assertEquals((long)1513036800000L, (long)((Date)result.getFirst()).getTime());
        result = SearchDateConversion.parseDateString((String)"NOW");
        Assert.assertEquals((long)14L, (long)((Integer)result.getSecond()).intValue());
        result = SearchDateConversion.parseDateString((String)"MIN");
        Assert.assertEquals((long)14L, (long)((Integer)result.getSecond()).intValue());
        result = SearchDateConversion.parseDateString((String)"TODAY");
        Assert.assertEquals((long)5L, (long)((Integer)result.getSecond()).intValue());
        result = SearchDateConversion.parseDateString((String)"MAX");
        Assert.assertEquals((long)14L, (long)((Integer)result.getSecond()).intValue());
        result = SearchDateConversion.parseDateString((String)"NONSENSE");
        Assert.assertNull((Object)result);
        result = SearchDateConversion.parseDateString((String)"NOW/YEAR");
        Assert.assertNull((Object)result);
        result = SearchDateConversion.parseDateString((String)"*");
        Assert.assertNull((Object)result);
    }

    @Test
    public void getDateEnd() throws Exception {
        this.setDefaults();
        Pair result = SearchDateConversion.parseDateString((String)"2017-12");
        Assert.assertEquals((Object)"2017-12-31T23:59:59.999Z", (Object)SearchDateConversion.getDateEnd((Pair)result));
        result = SearchDateConversion.parseDateString((String)"2017-12-12");
        Assert.assertEquals((Object)"2017-12-12T23:59:59.999Z", (Object)SearchDateConversion.getDateEnd((Pair)result));
        result = SearchDateConversion.parseDateString((String)"2017");
        Assert.assertEquals((Object)"2017-12-31T23:59:59.999Z", (Object)SearchDateConversion.getDateEnd((Pair)result));
    }

    @Test
    public void getDateStart() throws Exception {
        this.setDefaults();
        Pair result = SearchDateConversion.parseDateString((String)"2017-12");
        Assert.assertEquals((Object)"2017-12-01T00:00:00.000Z", (Object)SearchDateConversion.getDateStart((Pair)result));
        result = SearchDateConversion.parseDateString((String)"2017-12-12");
        Assert.assertEquals((Object)"2017-12-12T00:00:00.000Z", (Object)SearchDateConversion.getDateStart((Pair)result));
        result = SearchDateConversion.parseDateString((String)"2017");
        Assert.assertEquals((Object)"2017-01-01T00:00:00.000Z", (Object)SearchDateConversion.getDateStart((Pair)result));
    }

    @Test
    public void testIntervalDates() throws UnsupportedEncodingException {
        this.setDefaults();
        IntervalSet intervalSet = new IntervalSet("1", "10", "just numbers", Boolean.valueOf(false), Boolean.valueOf(true));
        IntervalSet validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)false);
        Assert.assertEquals((Object)intervalSet, (Object)validated);
        intervalSet = new IntervalSet("2006", "2010", "years", Boolean.valueOf(true), Boolean.valueOf(true));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2006-01-01T00:00:00.000Z", (Object)validated.getStart());
        Assert.assertTrue((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2010-12-31T23:59:59.999Z", (Object)validated.getEnd());
        Assert.assertTrue((boolean)validated.isEndInclusive());
        intervalSet = new IntervalSet("2006", "2010", "years", Boolean.valueOf(false), Boolean.valueOf(false));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2006-12-31T23:59:59.999Z", (Object)validated.getStart());
        Assert.assertFalse((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)validated.getEnd());
        Assert.assertFalse((boolean)validated.isEndInclusive());
        intervalSet = new IntervalSet("2006-09", "2010-03", "months", Boolean.valueOf(true), Boolean.valueOf(true));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2006-09-01T00:00:00.000Z", (Object)validated.getStart());
        Assert.assertTrue((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2010-03-31T23:59:59.999Z", (Object)validated.getEnd());
        Assert.assertTrue((boolean)validated.isEndInclusive());
        intervalSet = new IntervalSet("2006-09", "2010-03", "months", Boolean.valueOf(false), Boolean.valueOf(false));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2006-09-30T23:59:59.999Z", (Object)validated.getStart());
        Assert.assertFalse((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2010-03-01T00:00:00.000Z", (Object)validated.getEnd());
        Assert.assertFalse((boolean)validated.isEndInclusive());
        intervalSet = new IntervalSet("2017-09-01", "2017-09-30", "sept", Boolean.valueOf(true), Boolean.valueOf(true));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2017-09-01T00:00:00.000Z", (Object)validated.getStart());
        Assert.assertTrue((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2017-09-30T23:59:59.999Z", (Object)validated.getEnd());
        Assert.assertTrue((boolean)validated.isEndInclusive());
        intervalSet = new IntervalSet("2017-08-31", "2017-10-01", "sept", Boolean.valueOf(false), Boolean.valueOf(false));
        validated = SearchDateConversion.parseDateInterval((IntervalSet)intervalSet, (boolean)true);
        Assert.assertEquals((Object)"2017-08-31T23:59:59.999Z", (Object)validated.getStart());
        Assert.assertFalse((boolean)validated.isStartInclusive());
        Assert.assertEquals((Object)"2017-10-01T00:00:00.000Z", (Object)validated.getEnd());
        Assert.assertFalse((boolean)validated.isEndInclusive());
    }

    protected void setDefaults() {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }
}

