/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.Collection;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.ShadowTypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;

public class DocumentTypeDefinitionWrapper
extends ShadowTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    private DocumentTypeDefinitionImpl typeDef;
    private DocumentTypeDefinitionImpl typeDefInclProperties;
    private DictionaryService dictionaryService;

    public DocumentTypeDefinitionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new DocumentTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (cmisMapping.isValidCmisDocument(parentQName)) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, parentQName));
            }
        }
        this.typeDef.setDisplayName(null);
        this.typeDef.setDescription(null);
        this.typeDef.setIsCreatable(Boolean.valueOf(true));
        this.typeDef.setIsQueryable(Boolean.valueOf(true));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(true));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(true));
        this.typeDef.setIsIncludedInSupertypeQuery(cmisClassDef.getIncludedInSuperTypeQuery());
        this.typeDef.setIsFileable(Boolean.valueOf(true));
        this.typeDef.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        this.typeDef.setIsVersionable(Boolean.valueOf(true));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, accessorMapping, luceneBuilderMapping, dictionaryService, cmisClassDef);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_DOCUMENT);
    }

    @Override
    public void updateDefinition(DictionaryService dictionaryService) {
        TypeDefinition typeDef = dictionaryService.getType(this.alfrescoName);
        if (typeDef != null) {
            this.setTypeDefDisplayName(typeDef.getTitle(dictionaryService));
            this.setTypeDefDescription(typeDef.getDescription(dictionaryService));
        } else {
            super.updateDefinition(dictionaryService);
        }
        this.updateTypeDefInclProperties();
    }

    @Override
    public PropertyDefinitionWrapper getPropertyById(String propertyId) {
        this.updateProperty(this.dictionaryService, (PropertyDefinitionWrapper)this.propertiesById.get(propertyId));
        return (PropertyDefinitionWrapper)this.propertiesById.get(propertyId);
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties() {
        this.updateProperties(this.dictionaryService);
        return this.propertiesById.values();
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties(boolean update) {
        if (update) {
            return this.getProperties();
        }
        return this.propertiesById.values();
    }
}

