/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;

public class M2NamespaceDefinition
implements NamespaceDefinition {
    ModelDefinition model = null;
    private String uri = null;
    private String prefix = null;

    M2NamespaceDefinition(ModelDefinition model, String uri, String prefix) {
        this.model = model;
        this.uri = uri;
        this.prefix = prefix;
    }

    @Override
    public ModelDefinition getModel() {
        return this.model;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    static List<M2ModelDiff> diffNamespaceDefinitionLists(Collection<NamespaceDefinition> previousNamespaces, Collection<NamespaceDefinition> newNamespaces) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (NamespaceDefinition previousNamespace : previousNamespaces) {
            found = false;
            for (NamespaceDefinition newNamespace : newNamespaces) {
                if (!newNamespace.getUri().equals(previousNamespace.getUri())) continue;
                if (!newNamespace.getPrefix().equals(previousNamespace.getPrefix())) {
                    modelDiffs.add(new M2ModelDiff(newNamespace.getModel().getName(), newNamespace, "TYPE_NAMESPACE", "updated"));
                }
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousNamespace.getModel().getName(), "TYPE_NAMESPACE", "deleted"));
        }
        for (NamespaceDefinition newNamespace : newNamespaces) {
            found = false;
            for (NamespaceDefinition previousNamespace : previousNamespaces) {
                if (!newNamespace.getUri().equals(previousNamespace.getUri())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newNamespace.getModel().getName(), newNamespace, "TYPE_NAMESPACE", "created"));
        }
        return modelDiffs;
    }
}

