/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class QNameTest
extends TestCase {
    public QNameTest(String name) {
        super(name);
    }

    public void testInvalidQName() throws Exception {
        QName qname2;
        try {
            qname2 = QName.createQName((String)"");
            QNameTest.fail((String)"Missing local name was not caught");
        }
        catch (InvalidQNameException qname2) {
            // empty catch block
        }
        try {
            qname2 = QName.createQName((String)"invalid{}name");
            QNameTest.fail((String)"Namespace not at start was not caught");
        }
        catch (InvalidQNameException qname3) {
            // empty catch block
        }
        try {
            qname2 = QName.createQName((String)"{name");
            QNameTest.fail((String)"Missing closing namespace token was not caught");
        }
        catch (InvalidQNameException qname4) {
            // empty catch block
        }
        try {
            qname2 = QName.createQName((String)"{}");
            QNameTest.fail((String)"Missing local name after namespace was not caught");
        }
        catch (InvalidQNameException qname5) {
            // empty catch block
        }
        try {
            qname2 = QName.createQName((String)"{}name");
        }
        catch (InvalidQNameException e) {
            QNameTest.fail((String)"Empty namespace is valid");
        }
        try {
            qname2 = QName.createQName((String)"{namespace}name");
            QNameTest.assertEquals((String)"namespace", (String)qname2.getNamespaceURI());
            QNameTest.assertEquals((String)"name", (String)qname2.getLocalName());
        }
        catch (InvalidQNameException e) {
            QNameTest.fail((String)"Valid namespace has been thrown out");
        }
        try {
            qname2 = QName.createQName((String)null, (String)null);
            QNameTest.fail((String)"Null name was not caught");
        }
        catch (InvalidQNameException qname6) {
            // empty catch block
        }
        try {
            qname2 = QName.createQName((String)null, (String)"");
            QNameTest.fail((String)"Empty name was not caught");
        }
        catch (InvalidQNameException invalidQNameException) {
            // empty catch block
        }
    }

    public void testConstruction() {
        QName qname1 = QName.createQName((String)"namespace1", (String)"name1");
        QNameTest.assertEquals((String)"namespace1", (String)qname1.getNamespaceURI());
        QNameTest.assertEquals((String)"name1", (String)qname1.getLocalName());
        QName qname2 = QName.createQName((String)"{namespace2}name2");
        QNameTest.assertEquals((String)"namespace2", (String)qname2.getNamespaceURI());
        QNameTest.assertEquals((String)"name2", (String)qname2.getLocalName());
        QName qname3 = QName.createQName(null, (String)"name3");
        QNameTest.assertEquals((String)"", (String)qname3.getNamespaceURI());
        QName qname4 = QName.createQName((String)"", (String)"name4");
        QNameTest.assertEquals((String)"", (String)qname4.getNamespaceURI());
        QName qname5 = QName.createQName((String)"{}name5");
        QNameTest.assertEquals((String)"", (String)qname5.getNamespaceURI());
        QName qname6 = QName.createQName((String)"name6");
        QNameTest.assertEquals((String)"", (String)qname6.getNamespaceURI());
    }

    public void testStringRepresentation() {
        QName qname1 = QName.createQName((String)"namespace", (String)"name1");
        QNameTest.assertEquals((String)"{namespace}name1", (String)qname1.toString());
        QName qname2 = QName.createQName((String)"", (String)"name2");
        QNameTest.assertEquals((String)"{}name2", (String)qname2.toString());
        QName qname3 = QName.createQName((String)"{namespace}name3");
        QNameTest.assertEquals((String)"{namespace}name3", (String)qname3.toString());
        QName qname4 = QName.createQName((String)"{}name4");
        QNameTest.assertEquals((String)"{}name4", (String)qname4.toString());
        QName qname5 = QName.createQName((String)"name5");
        QNameTest.assertEquals((String)"{}name5", (String)qname5.toString());
    }

    public void testCommonTypes() {
        QName qname3 = QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}created");
        QNameTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}created", (String)qname3.toString());
        QName qname4 = QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}creator.__");
        QNameTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}creator.__", (String)qname4.toString());
        QName qname5 = QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}content.mimetype");
        QNameTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}content.mimetype", (String)qname5.toString());
    }

    public void testEquality() {
        QName qname1 = QName.createQName((String)"namespace", (String)"name");
        QName qname2 = QName.createQName((String)"namespace", (String)"name");
        QName qname3 = QName.createQName((String)"{namespace}name");
        QNameTest.assertEquals((Object)qname1, (Object)qname2);
        QNameTest.assertEquals((Object)qname1, (Object)qname3);
        QNameTest.assertEquals((int)qname1.hashCode(), (int)qname2.hashCode());
        QNameTest.assertEquals((int)qname1.hashCode(), (int)qname3.hashCode());
        QName qname4 = QName.createQName((String)"", (String)"name");
        QName qname5 = QName.createQName((String)"", (String)"name");
        QName qname6 = QName.createQName(null, (String)"name");
        QNameTest.assertEquals((Object)qname4, (Object)qname5);
        QNameTest.assertEquals((Object)qname4, (Object)qname6);
        QNameTest.assertEquals((int)qname4.hashCode(), (int)qname5.hashCode());
        QNameTest.assertEquals((int)qname4.hashCode(), (int)qname6.hashCode());
        QName qname7 = QName.createQName((String)"namespace", (String)"name");
        QName qname8 = QName.createQName((String)"namespace", (String)"differentname");
        QNameTest.assertFalse((boolean)qname7.equals((Object)qname8));
        QNameTest.assertFalse((qname7.hashCode() == qname8.hashCode() ? 1 : 0) != 0);
        QName qname9 = QName.createQName((String)"namespace", (String)"name");
        QName qname10 = QName.createQName((String)"differentnamespace", (String)"name");
        QNameTest.assertFalse((boolean)qname9.equals((Object)qname10));
        QNameTest.assertFalse((qname9.hashCode() == qname10.hashCode() ? 1 : 0) != 0);
    }

    public void testPrefix() {
        try {
            QName noResolver = QName.createQName((String)"alf", (String)"alfresco prefix", null);
            QNameTest.fail((String)"Null resolver was not caught");
        }
        catch (IllegalArgumentException noResolver) {
            // empty catch block
        }
        MockNamespacePrefixResolver mockResolver = new MockNamespacePrefixResolver();
        QName qname1 = QName.createQName((String)"alf", (String)"alfresco prefix", (NamespacePrefixResolver)mockResolver);
        QNameTest.assertEquals((String)"http://www.alfresco.org", (String)qname1.getNamespaceURI());
        QName qname2 = QName.createQName((String)"", (String)"default prefix", (NamespacePrefixResolver)mockResolver);
        QNameTest.assertEquals((String)"", (String)qname2.getNamespaceURI());
        QName qname3 = QName.createQName(null, (String)"null default prefix", (NamespacePrefixResolver)mockResolver);
        QNameTest.assertEquals((String)"", (String)qname3.getNamespaceURI());
        try {
            QName qname4 = QName.createQName((String)"garbage", (String)"garbage prefix", (NamespacePrefixResolver)mockResolver);
            QNameTest.fail((String)"Invalid Prefix was not caught");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public static class MockNamespacePrefixResolver
    implements NamespacePrefixResolver {
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return "";
            }
            if (prefix.equals("alf")) {
                return "http://www.alfresco.org";
            }
            throw new NamespaceException("Prefix " + prefix + " not registered");
        }

        public Collection<String> getPrefixes(String namespaceURI) {
            throw new NamespaceException("URI " + namespaceURI + " not registered");
        }

        public Collection<String> getPrefixes() {
            HashSet<String> prefixes = new HashSet<String>();
            prefixes.add("");
            prefixes.add("alf");
            return prefixes;
        }

        public Collection<String> getURIs() {
            HashSet<String> uris = new HashSet<String>();
            uris.add("");
            uris.add("http://www.alfresco.org");
            return uris;
        }
    }
}

