/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.util.HashSet;
import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class QueryParserUtils
implements QueryConstants {
    public static String expandQName(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, String qnameString) {
        Object fieldName = qnameString;
        if (qnameString.charAt(0) != '{') {
            String prefix;
            String uri;
            int colonPosition = qnameString.indexOf(58);
            fieldName = colonPosition == -1 ? "{" + defaultNameSpaceUri + "}" + qnameString : ((uri = QueryParserUtils.matchURI(namespacePrefixResolver, prefix = qnameString.substring(0, colonPosition))) == null ? "{" + defaultNameSpaceUri + "}" + qnameString : "{" + uri + "}" + qnameString.substring(colonPosition + 1));
        }
        return fieldName;
    }

    public static String matchURI(NamespacePrefixResolver namespacePrefixResolver, String prefix) {
        HashSet<String> prefixes = new HashSet<String>(namespacePrefixResolver.getPrefixes());
        if (prefixes.contains(prefix)) {
            return namespacePrefixResolver.getNamespaceURI(prefix);
        }
        String match = null;
        for (String candidate : prefixes) {
            if (!candidate.equalsIgnoreCase(prefix)) continue;
            if (match == null) {
                match = candidate;
                continue;
            }
            throw new NamespaceException("Ambiguous namespace prefix " + prefix);
        }
        if (match == null) {
            return null;
        }
        return namespacePrefixResolver.getNamespaceURI(match);
    }

    public static ClassDefinition matchClassDefinition(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String string) {
        QName search = QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string));
        ClassDefinition classDefinition = dictionaryService.getClass(QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string)));
        QName match = null;
        if (classDefinition == null) {
            for (QName definition : dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
            for (QName definition : dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
        } else {
            return classDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getClass(match);
    }

    public static AspectDefinition matchAspectDefinition(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String string) {
        QName search = QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string));
        AspectDefinition aspectDefinition = dictionaryService.getAspect(QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string)));
        QName match = null;
        if (aspectDefinition == null) {
            for (QName definition : dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
        } else {
            return aspectDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getAspect(match);
    }

    public static TypeDefinition matchTypeDefinition(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String string) {
        QName search = QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string));
        TypeDefinition typeDefinition = dictionaryService.getType(QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string)));
        QName match = null;
        if (typeDefinition == null) {
            for (QName definition : dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
        } else {
            return typeDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getType(match);
    }

    public static DataTypeDefinition matchDataTypeDefinition(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String string) {
        QName search = QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string));
        DataTypeDefinition dataTypeDefinition = dictionaryService.getDataType(QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string)));
        QName match = null;
        if (dataTypeDefinition == null) {
            for (QName definition : dictionaryService.getAllDataTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
        } else {
            return dataTypeDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getDataType(match);
    }

    public static PropertyDefinition matchPropertyDefinition(String defaultNameSpaceUri, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String string) {
        QName search = QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string));
        PropertyDefinition propertyDefinition = dictionaryService.getProperty(QName.createQName(QueryParserUtils.expandQName(defaultNameSpaceUri, namespacePrefixResolver, string)));
        QName match = null;
        if (propertyDefinition == null) {
            for (QName definition : dictionaryService.getAllProperties(null)) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new DictionaryException("Ambiguous data datype " + string);
            }
        } else {
            return propertyDefinition;
        }
        if (match == null) {
            return null;
        }
        return dictionaryService.getProperty(match);
    }

    public static Pair<String, String> extractFieldNameAndEnding(String field) {
        String propertyFieldName = null;
        String ending = "";
        if (field.endsWith(".mimetype")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".mimetype".length());
            ending = ".mimetype";
        } else if (field.endsWith(".size")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".size".length());
            ending = ".size";
        } else if (field.endsWith(".locale")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".locale".length());
            ending = ".locale";
        } else if (field.endsWith(".encoding")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".encoding".length());
            ending = ".encoding";
        } else if (field.endsWith("contentDocId")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "contentDocId".length());
            ending = "contentDocId";
        } else if (field.endsWith(".transformationException")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".transformationException".length());
            ending = ".transformationException";
        } else if (field.endsWith(".transformationTime")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".transformationTime".length());
            ending = ".transformationTime";
        } else if (field.endsWith(".transformationStatus")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".transformationStatus".length());
            ending = ".transformationStatus";
        } else if (field.endsWith(".__.u")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".__.u".length());
            ending = ".__.u";
        } else if (field.endsWith(".u")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".u".length());
            ending = ".u";
        } else if (field.endsWith(".__")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - ".__".length());
            ending = ".__";
        } else if (field.endsWith("_unit_of_time_second")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_second".length());
            ending = "_unit_of_time_second";
        } else if (field.endsWith("_unit_of_time_minute")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_minute".length());
            ending = "_unit_of_time_minute";
        } else if (field.endsWith("_unit_of_time_hour")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_hour".length());
            ending = "_unit_of_time_hour";
        } else if (field.endsWith("_unit_of_time_day_of_month")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_day_of_month".length());
            ending = "_unit_of_time_day_of_month";
        } else if (field.endsWith("_unit_of_time_day_of_week")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_day_of_week".length());
            ending = "_unit_of_time_day_of_week";
        } else if (field.endsWith("_unit_of_time_day_of_year")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_day_of_year".length());
            ending = "_unit_of_time_day_of_year";
        } else if (field.endsWith("_unit_of_time_month")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_month".length());
            ending = "_unit_of_time_month";
        } else if (field.endsWith("_unit_of_time_quarter")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_quarter".length());
            ending = "_unit_of_time_quarter";
        } else if (field.endsWith("_unit_of_time_year")) {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0, field.length() - "_unit_of_time_year".length());
            ending = "_unit_of_time_year";
        } else {
            propertyFieldName = field.substring(field.startsWith("@") ? 1 : 0);
        }
        return new Pair((Object)propertyFieldName, (Object)ending);
    }
}

