/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.util.cache.AbstractAsynchronouslyRefreshedCache;
import org.alfresco.util.cache.RefreshableCacheEvent;
import org.alfresco.util.cache.RefreshableCacheListener;
import org.alfresco.util.cache.RefreshableCacheRefreshedEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompiledModelsCache
extends AbstractAsynchronouslyRefreshedCache<DictionaryRegistry> {
    private static Log logger = LogFactory.getLog(CompiledModelsCache.class);
    private DictionaryDAOImpl dictionaryDAO;
    private TenantService tenantService;

    protected DictionaryRegistry buildCache(String tenantId) {
        if (tenantId == null) {
            tenantId = this.tenantService.getCurrentUserDomain();
        }
        final String finalTenant = tenantId;
        return AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<DictionaryRegistry>(){

            @Override
            public DictionaryRegistry doWork() throws Exception {
                return CompiledModelsCache.this.dictionaryDAO.initDictionaryRegistry(finalTenant);
            }
        }, this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantId));
    }

    public void remove(String tenantId) {
        this.liveLock.writeLock().lock();
        try {
            DictionaryRegistry dictionaryRegistry = (DictionaryRegistry)this.live.get(tenantId);
            if (dictionaryRegistry != null) {
                this.live.remove(tenantId);
                dictionaryRegistry.remove();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed dictionary register for tenant " + tenantId));
                }
            }
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
    }

    public void setDictionaryDAO(DictionaryDAOImpl dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.register(new RefreshableCacheListener(){

            public void onRefreshableCacheEvent(RefreshableCacheEvent event) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Handling " + event.getClass().getSimpleName() + ", cache=" + event.getCacheId() + ", key=" + event.getKey()));
                }
                if (event instanceof RefreshableCacheRefreshedEvent && event.getCacheId().equals(this.getCacheId())) {
                    for (DictionaryListener dictionaryListener : CompiledModelsCache.this.dictionaryDAO.getDictionaryListeners()) {
                        logger.debug((Object)("Calling afterDIctionaryInit [" + event.getClass().getSimpleName() + ", cache=" + event.getCacheId() + ", key=" + event.getKey() + "] on " + dictionaryListener.getClass().getSimpleName()));
                        dictionaryListener.afterDictionaryInit();
                    }
                }
            }

            public String getCacheId() {
                return CompiledModelsCache.this.getCacheId();
            }
        });
    }
}

