/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2ClassAssociation;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2PropertyOverride;

public abstract class M2Class {
    public static final Pattern PROPERTY_PLACEHOLDER = Pattern.compile("\\$\\{.*\\}\\|.*");
    private String name = null;
    private String title = null;
    private String description = null;
    private String parentName = null;
    private Boolean archive = null;
    private Boolean includedInSuperTypeQuery = null;
    private String analyserResourceBundleName = null;
    private List<M2Property> properties = new ArrayList<M2Property>();
    private List<M2PropertyOverride> propertyOverrides = new ArrayList<M2PropertyOverride>();
    private List<M2ClassAssociation> associations = new ArrayList<M2ClassAssociation>();
    private List<String> mandatoryAspects = new ArrayList<String>();
    public static final String JiBX_bindingList = "|org.alfresco.repo.dictionary.JiBX_defaultFactory|";

    M2Class() {
    }

    public boolean isAspect() {
        return this instanceof M2Aspect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Boolean getArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public Boolean getIncludedInSuperTypeQuery() {
        return this.includedInSuperTypeQuery;
    }

    public void setIncludedInSuperTypeQuery(boolean includedInSuperTypeQuery) {
        this.includedInSuperTypeQuery = includedInSuperTypeQuery;
    }

    public M2Property createProperty(String name) {
        M2Property property = new M2Property();
        property.setName(name);
        this.properties.add(property);
        return property;
    }

    public void removeProperty(String name) {
        M2Property property = this.getProperty(name);
        if (property != null) {
            this.properties.remove(property);
        }
    }

    public List<M2Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public M2Property getProperty(String name) {
        for (M2Property candidate : this.properties) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Association createAssociation(String name) {
        M2Association association = new M2Association();
        association.setName(name);
        this.associations.add(association);
        return association;
    }

    public M2ChildAssociation createChildAssociation(String name) {
        M2ChildAssociation association = new M2ChildAssociation();
        association.setName(name);
        this.associations.add(association);
        return association;
    }

    public void removeAssociation(String name) {
        M2ClassAssociation association = this.getAssociation(name);
        if (association != null) {
            this.associations.remove(association);
        }
    }

    public List<M2ClassAssociation> getAssociations() {
        return Collections.unmodifiableList(this.associations);
    }

    public M2ClassAssociation getAssociation(String name) {
        for (M2ClassAssociation candidate : this.associations) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2PropertyOverride createPropertyOverride(String name) {
        M2PropertyOverride property = new M2PropertyOverride();
        property.setName(name);
        this.propertyOverrides.add(property);
        return property;
    }

    public void removePropertyOverride(String name) {
        M2PropertyOverride property = this.getPropertyOverride(name);
        if (property != null) {
            this.propertyOverrides.remove(property);
        }
    }

    public List<M2PropertyOverride> getPropertyOverrides() {
        return Collections.unmodifiableList(this.propertyOverrides);
    }

    public M2PropertyOverride getPropertyOverride(String name) {
        for (M2PropertyOverride candidate : this.propertyOverrides) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public void addMandatoryAspect(String name) {
        this.mandatoryAspects.add(name);
    }

    public void removeMandatoryAspect(String name) {
        this.mandatoryAspects.remove(name);
    }

    public List<String> getMandatoryAspects() {
        return Collections.unmodifiableList(this.mandatoryAspects);
    }

    public void setConfigProperties(Properties configProperties) {
        if (this.properties != null) {
            for (M2Property property : this.properties) {
                property.setConfigProperties(configProperties);
            }
        }
        if (this.propertyOverrides != null) {
            for (M2PropertyOverride propertyOverride : this.propertyOverrides) {
                propertyOverride.setConfigProperties(configProperties);
            }
        }
    }

    public /* synthetic */ void JiBX_access_store_name_1_0(String arg1) {
        this.name = arg1;
    }

    public /* synthetic */ void JiBX_access_store_title_1_0(String arg1) {
        this.title = arg1;
    }

    public /* synthetic */ void JiBX_access_store_description_1_0(String arg1) {
        this.description = arg1;
    }

    public /* synthetic */ void JiBX_access_store_parentName_1_0(String arg1) {
        this.parentName = arg1;
    }

    public /* synthetic */ void JiBX_access_store_archive_1_0(Boolean arg1) {
        this.archive = arg1;
    }

    public /* synthetic */ void JiBX_access_store_includedInSuperTypeQuery_1_0(Boolean arg1) {
        this.includedInSuperTypeQuery = arg1;
    }

    public /* synthetic */ void JiBX_access_store_analyserResourceBundleName_1_0(String arg1) {
        this.analyserResourceBundleName = arg1;
    }

    public /* synthetic */ List JiBX_access_load_properties_1_0() {
        return this.properties;
    }

    public /* synthetic */ void JiBX_access_store_properties_1_0(List arg1) {
        this.properties = arg1;
    }

    public /* synthetic */ List JiBX_access_load_associations_1_0() {
        return this.associations;
    }

    public /* synthetic */ void JiBX_access_store_associations_1_0(List arg1) {
        this.associations = arg1;
    }

    public /* synthetic */ List JiBX_access_load_propertyOverrides_1_0() {
        return this.propertyOverrides;
    }

    public /* synthetic */ void JiBX_access_store_propertyOverrides_1_0(List arg1) {
        this.propertyOverrides = arg1;
    }

    public /* synthetic */ List JiBX_access_load_mandatoryAspects_1_0() {
        return this.mandatoryAspects;
    }

    public /* synthetic */ void JiBX_access_store_mandatoryAspects_1_0(List arg1) {
        this.mandatoryAspects = arg1;
    }

    public /* synthetic */ String JiBX_access_load_name_1_0() {
        return this.name;
    }

    public /* synthetic */ String JiBX_access_load_title_1_0() {
        return this.title;
    }

    public /* synthetic */ String JiBX_access_load_description_1_0() {
        return this.description;
    }

    public /* synthetic */ String JiBX_access_load_parentName_1_0() {
        return this.parentName;
    }

    public /* synthetic */ Boolean JiBX_access_load_archive_1_0() {
        return this.archive;
    }

    public /* synthetic */ Boolean JiBX_access_load_includedInSuperTypeQuery_1_0() {
        return this.includedInSuperTypeQuery;
    }

    public /* synthetic */ String JiBX_access_load_analyserResourceBundleName_1_0() {
        return this.analyserResourceBundleName;
    }
}

